/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.PublicApi;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

@PublicApi
public class Relay {
    public static final String NODE = "Node";
    public static final GraphQLObjectType pageInfoType = GraphQLObjectType.newObject().name("PageInfo").description("Information about pagination in a connection.").field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).description("When paginating forwards, are there more items?")).field(GraphQLFieldDefinition.newFieldDefinition().name("hasPreviousPage").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean)).description("When paginating backwards, are there more items?")).field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").type(Scalars.GraphQLString).description("When paginating backwards, the cursor to continue.")).field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").type(Scalars.GraphQLString).description("When paginating forwards, the cursor to continue.")).build();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();

    public GraphQLInterfaceType nodeInterface(TypeResolver typeResolver) {
        return GraphQLInterfaceType.newInterface().name(NODE).description("An object with an ID").typeResolver(typeResolver).field(GraphQLFieldDefinition.newFieldDefinition().name("id").description("The ID of an object").type(GraphQLNonNull.nonNull(Scalars.GraphQLID))).build();
    }

    public GraphQLFieldDefinition nodeField(GraphQLInterfaceType nodeInterface, DataFetcher nodeDataFetcher) {
        return GraphQLFieldDefinition.newFieldDefinition().name("node").description("Fetches an object given its ID").type(nodeInterface).dataFetcher(nodeDataFetcher).argument(GraphQLArgument.newArgument().name("id").description("The ID of an object").type(GraphQLNonNull.nonNull(Scalars.GraphQLID))).build();
    }

    public List<GraphQLArgument> getConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args2 = new ArrayList<GraphQLArgument>();
        args2.add(GraphQLArgument.newArgument().name("before").description("fetching only nodes before this node (exclusive)").type(Scalars.GraphQLString).build());
        args2.add(GraphQLArgument.newArgument().name("after").description("fetching only nodes after this node (exclusive)").type(Scalars.GraphQLString).build());
        args2.add(GraphQLArgument.newArgument().name("first").description("fetching only the first certain number of nodes").type(Scalars.GraphQLInt).build());
        args2.add(GraphQLArgument.newArgument().name("last").description("fetching only the last certain number of nodes").type(Scalars.GraphQLInt).build());
        return args2;
    }

    public List<GraphQLArgument> getBackwardPaginationConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args2 = new ArrayList<GraphQLArgument>();
        args2.add(GraphQLArgument.newArgument().name("before").description("fetching only nodes before this node (exclusive)").type(Scalars.GraphQLString).build());
        args2.add(GraphQLArgument.newArgument().name("last").description("fetching only the last certain number of nodes").type(Scalars.GraphQLInt).build());
        return args2;
    }

    public List<GraphQLArgument> getForwardPaginationConnectionFieldArguments() {
        ArrayList<GraphQLArgument> args2 = new ArrayList<GraphQLArgument>();
        args2.add(GraphQLArgument.newArgument().name("after").description("fetching only nodes after this node (exclusive)").type(Scalars.GraphQLString).build());
        args2.add(GraphQLArgument.newArgument().name("first").description("fetching only the first certain number of nodes").type(Scalars.GraphQLInt).build());
        return args2;
    }

    public GraphQLObjectType edgeType(String name, GraphQLOutputType nodeType, GraphQLInterfaceType nodeInterface, List<GraphQLFieldDefinition> edgeFields) {
        return GraphQLObjectType.newObject().name(name + "Edge").description("An edge in a connection").field(GraphQLFieldDefinition.newFieldDefinition().name("node").type(nodeType).description("The item at the end of the edge")).field(GraphQLFieldDefinition.newFieldDefinition().name("cursor").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("cursor marks a unique position or index into the connection")).fields(edgeFields).build();
    }

    public GraphQLObjectType connectionType(String name, GraphQLObjectType edgeType, List<GraphQLFieldDefinition> connectionFields) {
        return GraphQLObjectType.newObject().name(name + "Connection").description("A connection to a list of items.").field(GraphQLFieldDefinition.newFieldDefinition().name("edges").description("a list of edges").type(GraphQLList.list(edgeType))).field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").description("details about this specific page").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("PageInfo")))).fields(connectionFields).build();
    }

    public GraphQLFieldDefinition mutationWithClientMutationId(String name, String fieldName, List<GraphQLInputObjectField> inputFields, List<GraphQLFieldDefinition> outputFields, DataFetcher dataFetcher) {
        GraphQLInputObjectField clientMutationIdInputField = GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type(Scalars.GraphQLString).build();
        GraphQLFieldDefinition clientMutationIdPayloadField = GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type(Scalars.GraphQLString).build();
        return this.mutation(name, fieldName, Relay.addElementToList(inputFields, clientMutationIdInputField), Relay.addElementToList(outputFields, clientMutationIdPayloadField), dataFetcher);
    }

    private static <T> List<T> addElementToList(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return result;
    }

    public GraphQLFieldDefinition mutation(String name, String fieldName, List<GraphQLInputObjectField> inputFields, List<GraphQLFieldDefinition> outputFields, DataFetcher dataFetcher) {
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(name + "Input").fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(name + "Payload").fields(outputFields).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(fieldName).type(outputType).argument(GraphQLArgument.newArgument().name("input").type(GraphQLNonNull.nonNull(inputObjectType))).dataFetcher(dataFetcher).build();
    }

    public String toGlobalId(String type, String id) {
        return encoder.encodeToString((type + ":" + id).getBytes(StandardCharsets.UTF_8));
    }

    public ResolvedGlobalId fromGlobalId(String globalId) {
        String[] split = new String(decoder.decode(globalId), StandardCharsets.UTF_8).split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException(String.format("expecting a valid global id, got %s", globalId));
        }
        return new ResolvedGlobalId(split[0], split[1]);
    }

    public static class ResolvedGlobalId {
        private final String type;
        private final String id;

        public ResolvedGlobalId(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }
    }
}

