/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff;

import graphql.PublicApi;
import graphql.language.TypeKind;
import graphql.schema.diff.DiffCategory;
import graphql.schema.diff.DiffLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@PublicApi
public class DiffEvent {
    private final DiffLevel level;
    private final DiffCategory category;
    private final TypeKind typeOfType;
    private final String typeName;
    private final String fieldName;
    private final String reasonMsg;
    private final List<String> components;

    DiffEvent(DiffLevel level, DiffCategory category, String typeName, String fieldName, TypeKind typeOfType, String reasonMsg, List<String> components) {
        this.level = level;
        this.category = category;
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.typeOfType = typeOfType;
        this.reasonMsg = reasonMsg;
        this.components = components;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TypeKind getTypeKind() {
        return this.typeOfType;
    }

    public String getReasonMsg() {
        return this.reasonMsg;
    }

    public DiffLevel getLevel() {
        return this.level;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public DiffCategory getCategory() {
        return this.category;
    }

    public List<String> getComponents() {
        return new ArrayList<String>(this.components);
    }

    public String toString() {
        return "DifferenceEvent{ reasonMsg='" + this.reasonMsg + "', level=" + String.valueOf((Object)this.level) + ", category=" + String.valueOf((Object)this.category) + ", typeName='" + this.typeName + "', typeKind=" + String.valueOf((Object)this.typeOfType) + ", fieldName=" + this.fieldName + "}";
    }

    public static Builder apiInfo() {
        return new Builder().level(DiffLevel.INFO);
    }

    public static Builder apiDanger() {
        return new Builder().level(DiffLevel.DANGEROUS);
    }

    public static Builder apiBreakage() {
        return new Builder().level(DiffLevel.BREAKING);
    }

    public static class Builder {
        DiffCategory category;
        DiffLevel level;
        String typeName;
        TypeKind typeOfType;
        String reasonMsg;
        String fieldName;
        final List<String> components = new ArrayList<String>();

        public Builder level(DiffLevel level) {
            this.level = level;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder typeKind(TypeKind typeOfType) {
            this.typeOfType = typeOfType;
            return this;
        }

        public Builder category(DiffCategory category) {
            this.category = category;
            return this;
        }

        public Builder reasonMsg(String format, Object ... args2) {
            this.reasonMsg = String.format(format, args2);
            return this;
        }

        public Builder components(Object ... args2) {
            this.components.addAll(Arrays.stream(args2).map(String::valueOf).collect(Collectors.toList()));
            return this;
        }

        public DiffEvent build() {
            return new DiffEvent(this.level, this.category, this.typeName, this.fieldName, this.typeOfType, this.reasonMsg, this.components);
        }
    }
}

