/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.ArgValueOfAllowedTypeChecker;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeUtil;
import graphql.schema.idl.errors.DirectiveIllegalLocationError;
import graphql.schema.idl.errors.DirectiveIllegalReferenceError;
import graphql.schema.idl.errors.DirectiveMissingNonNullArgumentError;
import graphql.schema.idl.errors.DirectiveUndeclaredError;
import graphql.schema.idl.errors.DirectiveUnknownArgumentError;
import graphql.schema.idl.errors.IllegalNameError;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.util.FpKit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
class SchemaTypeDirectivesChecker {
    private final TypeDefinitionRegistry typeRegistry;
    private final RuntimeWiring runtimeWiring;

    public SchemaTypeDirectivesChecker(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        this.typeRegistry = typeRegistry;
        this.runtimeWiring = runtimeWiring;
    }

    void checkTypeDirectives(List<GraphQLError> errors2) {
        this.typeRegistry.objectTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.OBJECT, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.interfaceTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.INTERFACE, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.unionTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.UNION, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.enumTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.ENUM, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.scalarTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.SCALAR, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.inputObjectTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_OBJECT, errors2, (TypeDefinition<?>)ext)));
        this.typeRegistry.getTypes(ObjectTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.OBJECT, errors2, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(InterfaceTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.INTERFACE, errors2, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(UnionTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.UNION, errors2, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(EnumTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.ENUM, errors2, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(InputObjectTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_OBJECT, errors2, (TypeDefinition<?>)typeDef));
        this.typeRegistry.scalars().values().forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.SCALAR, errors2, (TypeDefinition<?>)typeDef));
        List<Directive> schemaDirectives = SchemaExtensionsChecker.gatherSchemaDirectives(this.typeRegistry, errors2);
        SchemaDefinition schemaDefinition = this.typeRegistry.schemaDefinition().orElse(SchemaDefinition.newSchemaDefinition().build());
        this.checkDirectives(Introspection.DirectiveLocation.SCHEMA, errors2, this.typeRegistry, schemaDefinition, "schema", schemaDirectives);
        Collection<DirectiveDefinition> directiveDefinitions = this.typeRegistry.getDirectiveDefinitions().values();
        this.commonCheck(directiveDefinitions, errors2);
    }

    private void checkDirectives(Introspection.DirectiveLocation expectedLocation, List<GraphQLError> errors2, TypeDefinition<?> typeDef) {
        List<FieldDefinition> fieldDefinitions;
        this.checkDirectives(expectedLocation, errors2, this.typeRegistry, typeDef, typeDef.getName(), typeDef.getDirectives());
        if (typeDef instanceof ObjectTypeDefinition) {
            fieldDefinitions = ((ObjectTypeDefinition)typeDef).getFieldDefinitions();
            this.checkFieldsDirectives(errors2, this.typeRegistry, fieldDefinitions);
        }
        if (typeDef instanceof InterfaceTypeDefinition) {
            fieldDefinitions = ((InterfaceTypeDefinition)typeDef).getFieldDefinitions();
            this.checkFieldsDirectives(errors2, this.typeRegistry, fieldDefinitions);
        }
        if (typeDef instanceof EnumTypeDefinition) {
            List<EnumValueDefinition> enumValueDefinitions = ((EnumTypeDefinition)typeDef).getEnumValueDefinitions();
            enumValueDefinitions.forEach(definition -> this.checkDirectives(Introspection.DirectiveLocation.ENUM_VALUE, errors2, this.typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives()));
        }
        if (typeDef instanceof InputObjectTypeDefinition) {
            List<InputValueDefinition> inputValueDefinitions = ((InputObjectTypeDefinition)typeDef).getInputValueDefinitions();
            inputValueDefinitions.forEach(definition -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, errors2, this.typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives()));
        }
    }

    private void checkFieldsDirectives(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, List<FieldDefinition> fieldDefinitions) {
        fieldDefinitions.forEach(definition -> {
            this.checkDirectives(Introspection.DirectiveLocation.FIELD_DEFINITION, errors2, typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives());
            definition.getInputValueDefinitions().forEach(arg -> this.checkDirectives(Introspection.DirectiveLocation.ARGUMENT_DEFINITION, errors2, typeRegistry, (Node<?>)arg, arg.getName(), arg.getDirectives()));
        });
    }

    private void checkDirectives(Introspection.DirectiveLocation expectedLocation, List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Node<?> element, String elementName, List<Directive> directives) {
        directives.forEach(directive -> {
            Optional<DirectiveDefinition> directiveDefinition = typeRegistry.getDirectiveDefinition(directive.getName());
            if (!directiveDefinition.isPresent()) {
                errors2.add(new DirectiveUndeclaredError(element, elementName, directive.getName()));
            } else {
                if (!this.inRightLocation(expectedLocation, directiveDefinition.get())) {
                    errors2.add(new DirectiveIllegalLocationError(element, elementName, directive.getName(), expectedLocation.name()));
                }
                this.checkDirectiveArguments(errors2, typeRegistry, element, elementName, (Directive)directive, directiveDefinition.get());
            }
        });
    }

    private boolean inRightLocation(Introspection.DirectiveLocation expectedLocation, DirectiveDefinition directiveDefinition) {
        List names = directiveDefinition.getDirectiveLocations().stream().map(DirectiveLocation::getName).map(String::toUpperCase).collect(Collectors.toList());
        return names.contains(expectedLocation.name().toUpperCase());
    }

    private void checkDirectiveArguments(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Node element, String elementName, Directive directive, DirectiveDefinition directiveDefinition) {
        Map<String, InputValueDefinition> allowedArgs = FpKit.getByName(directiveDefinition.getInputValueDefinitions(), InputValueDefinition::getName, FpKit.mergeFirst());
        Map<String, Argument> providedArgs = FpKit.getByName(directive.getArguments(), Argument::getName, FpKit.mergeFirst());
        directive.getArguments().forEach(argument -> {
            InputValueDefinition allowedArg = (InputValueDefinition)allowedArgs.get(argument.getName());
            if (allowedArg == null) {
                errors2.add(new DirectiveUnknownArgumentError(element, elementName, directive.getName(), argument.getName()));
            } else {
                ArgValueOfAllowedTypeChecker argValueOfAllowedTypeChecker = new ArgValueOfAllowedTypeChecker(directive, element, elementName, (Argument)argument, typeRegistry, this.runtimeWiring);
                argValueOfAllowedTypeChecker.checkArgValueMatchesAllowedType(errors2, argument.getValue(), allowedArg.getType());
            }
        });
        allowedArgs.forEach((argName, definitionArgument) -> {
            if (this.isNoNullArgWithoutDefaultValue((InputValueDefinition)definitionArgument) && !providedArgs.containsKey(argName)) {
                errors2.add(new DirectiveMissingNonNullArgumentError(element, elementName, directive.getName(), (String)argName));
            }
        });
    }

    private boolean isNoNullArgWithoutDefaultValue(InputValueDefinition definitionArgument) {
        return definitionArgument.getType() instanceof NonNullType && definitionArgument.getDefaultValue() == null;
    }

    private void commonCheck(Collection<DirectiveDefinition> directiveDefinitions, List<GraphQLError> errors2) {
        directiveDefinitions.forEach(directiveDefinition -> {
            this.assertTypeName((NamedNode)directiveDefinition, errors2);
            directiveDefinition.getInputValueDefinitions().forEach(inputValueDefinition -> {
                this.assertTypeName((NamedNode)inputValueDefinition, errors2);
                this.assertExistAndIsInputType((InputValueDefinition)inputValueDefinition, errors2);
                if (inputValueDefinition.hasDirective(directiveDefinition.getName())) {
                    errors2.add(new DirectiveIllegalReferenceError((DirectiveDefinition)directiveDefinition, (NamedNode)inputValueDefinition));
                }
            });
        });
    }

    private void assertTypeName(NamedNode node, List<GraphQLError> errors2) {
        if (node.getName().length() >= 2 && node.getName().startsWith("__")) {
            errors2.add(new IllegalNameError(node));
        }
    }

    public void assertExistAndIsInputType(InputValueDefinition definition, List<GraphQLError> errors2) {
        TypeName namedType = TypeUtil.unwrapAll(definition.getType());
        TypeDefinition unwrappedType = this.findTypeDefFromRegistry(namedType.getName(), this.typeRegistry);
        if (unwrappedType == null) {
            errors2.add(new MissingTypeError(namedType.getName(), definition, definition.getName()));
            return;
        }
        if (!(unwrappedType instanceof InputObjectTypeDefinition || unwrappedType instanceof EnumTypeDefinition || unwrappedType instanceof ScalarTypeDefinition)) {
            errors2.add(new NotAnInputTypeError(namedType, unwrappedType));
        }
    }

    private TypeDefinition findTypeDefFromRegistry(String typeName, TypeDefinitionRegistry typeRegistry) {
        return typeRegistry.getType(typeName).orElseGet(() -> typeRegistry.scalars().get(typeName));
    }
}

