/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.NamedNode;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaParseOrder;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.DirectiveRedefinitionError;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.idl.errors.SchemaRedefinitionError;
import graphql.schema.idl.errors.TypeRedefinitionError;
import graphql.util.FpKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@PublicApi
public class TypeDefinitionRegistry
implements Serializable {
    private final Map<String, List<ObjectTypeExtensionDefinition>> objectTypeExtensions = new LinkedHashMap<String, List<ObjectTypeExtensionDefinition>>();
    private final Map<String, List<InterfaceTypeExtensionDefinition>> interfaceTypeExtensions = new LinkedHashMap<String, List<InterfaceTypeExtensionDefinition>>();
    private final Map<String, List<UnionTypeExtensionDefinition>> unionTypeExtensions = new LinkedHashMap<String, List<UnionTypeExtensionDefinition>>();
    private final Map<String, List<EnumTypeExtensionDefinition>> enumTypeExtensions = new LinkedHashMap<String, List<EnumTypeExtensionDefinition>>();
    private final Map<String, List<ScalarTypeExtensionDefinition>> scalarTypeExtensions = new LinkedHashMap<String, List<ScalarTypeExtensionDefinition>>();
    private final Map<String, List<InputObjectTypeExtensionDefinition>> inputObjectTypeExtensions = new LinkedHashMap<String, List<InputObjectTypeExtensionDefinition>>();
    private final Map<String, TypeDefinition> types = new LinkedHashMap<String, TypeDefinition>();
    private final Map<String, ScalarTypeDefinition> scalarTypes = new LinkedHashMap<String, ScalarTypeDefinition>();
    private final Map<String, DirectiveDefinition> directiveDefinitions = new LinkedHashMap<String, DirectiveDefinition>();
    private SchemaDefinition schema;
    private final List<SchemaExtensionDefinition> schemaExtensionDefinitions = new ArrayList<SchemaExtensionDefinition>();
    private final SchemaParseOrder schemaParseOrder = new SchemaParseOrder();

    public SchemaParseOrder getParseOrder() {
        return this.schemaParseOrder;
    }

    public TypeDefinitionRegistry merge(TypeDefinitionRegistry typeRegistry) throws SchemaProblem {
        ArrayList<GraphQLError> errors2 = new ArrayList<GraphQLError>();
        LinkedHashMap tempTypes = new LinkedHashMap();
        typeRegistry.types.values().forEach(newEntry -> {
            Optional<GraphQLError> defined = this.define(this.types, tempTypes, newEntry);
            defined.ifPresent(errors2::add);
        });
        LinkedHashMap tempDirectiveDefs = new LinkedHashMap();
        typeRegistry.directiveDefinitions.values().forEach(newEntry -> {
            Optional<GraphQLError> defined = this.define(this.directiveDefinitions, tempDirectiveDefs, newEntry);
            defined.ifPresent(errors2::add);
        });
        LinkedHashMap tempScalarTypes = new LinkedHashMap();
        typeRegistry.scalarTypes.values().forEach(newEntry -> this.define(this.scalarTypes, tempScalarTypes, newEntry).ifPresent(errors2::add));
        this.checkMergeSchemaDefs(typeRegistry, errors2);
        if (!errors2.isEmpty()) {
            throw new SchemaProblem(errors2);
        }
        if (this.schema == null) {
            this.schema = typeRegistry.schema;
            this.schemaParseOrder.addDefinition(typeRegistry.schema);
        }
        this.schemaExtensionDefinitions.addAll(typeRegistry.schemaExtensionDefinitions);
        typeRegistry.schemaExtensionDefinitions.forEach(this.schemaParseOrder::addDefinition);
        this.types.putAll(tempTypes);
        this.scalarTypes.putAll(tempScalarTypes);
        this.directiveDefinitions.putAll(tempDirectiveDefs);
        typeRegistry.objectTypeExtensions.forEach((key, value) -> {
            List currentList = this.objectTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.interfaceTypeExtensions.forEach((key, value) -> {
            List currentList = this.interfaceTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.unionTypeExtensions.forEach((key, value) -> {
            List currentList = this.unionTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.enumTypeExtensions.forEach((key, value) -> {
            List currentList = this.enumTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.scalarTypeExtensions.forEach((key, value) -> {
            List currentList = this.scalarTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.inputObjectTypeExtensions.forEach((key, value) -> {
            List currentList = this.inputObjectTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        return this;
    }

    private Map<String, OperationTypeDefinition> checkMergeSchemaDefs(TypeDefinitionRegistry toBeMergedTypeRegistry, List<GraphQLError> errors2) {
        if (toBeMergedTypeRegistry.schema != null && this.schema != null) {
            errors2.add(new SchemaRedefinitionError(this.schema, toBeMergedTypeRegistry.schema));
        }
        Map<String, OperationTypeDefinition> tempOperationDefs = SchemaExtensionsChecker.gatherOperationDefs(errors2, this.schema, this.schemaExtensionDefinitions);
        Map<String, OperationTypeDefinition> mergedOperationDefs = SchemaExtensionsChecker.gatherOperationDefs(errors2, toBeMergedTypeRegistry.schema, toBeMergedTypeRegistry.schemaExtensionDefinitions);
        SchemaExtensionsChecker.defineOperationDefs(errors2, mergedOperationDefs.values(), tempOperationDefs);
        return tempOperationDefs;
    }

    private Optional<GraphQLError> checkAddOperationDefs() {
        ArrayList<GraphQLError> errors2 = new ArrayList<GraphQLError>();
        SchemaExtensionsChecker.gatherOperationDefs(errors2, this.schema, this.schemaExtensionDefinitions);
        if (!errors2.isEmpty()) {
            return Optional.of((GraphQLError)errors2.get(0));
        }
        return Optional.empty();
    }

    public Optional<GraphQLError> addAll(Collection<SDLDefinition> definitions) {
        for (SDLDefinition definition : definitions) {
            Optional<GraphQLError> error = this.add(definition);
            if (!error.isPresent()) continue;
            return error;
        }
        return Optional.empty();
    }

    public Optional<GraphQLError> add(SDLDefinition definition) {
        if (definition instanceof ObjectTypeExtensionDefinition) {
            ObjectTypeExtensionDefinition newEntry = (ObjectTypeExtensionDefinition)definition;
            return this.defineExt(this.objectTypeExtensions, newEntry, ObjectTypeDefinition::getName);
        }
        if (definition instanceof InterfaceTypeExtensionDefinition) {
            InterfaceTypeExtensionDefinition newEntry = (InterfaceTypeExtensionDefinition)definition;
            return this.defineExt(this.interfaceTypeExtensions, newEntry, InterfaceTypeDefinition::getName);
        }
        if (definition instanceof UnionTypeExtensionDefinition) {
            UnionTypeExtensionDefinition newEntry = (UnionTypeExtensionDefinition)definition;
            return this.defineExt(this.unionTypeExtensions, newEntry, UnionTypeDefinition::getName);
        }
        if (definition instanceof EnumTypeExtensionDefinition) {
            EnumTypeExtensionDefinition newEntry = (EnumTypeExtensionDefinition)definition;
            return this.defineExt(this.enumTypeExtensions, newEntry, EnumTypeDefinition::getName);
        }
        if (definition instanceof ScalarTypeExtensionDefinition) {
            ScalarTypeExtensionDefinition newEntry = (ScalarTypeExtensionDefinition)definition;
            return this.defineExt(this.scalarTypeExtensions, newEntry, ScalarTypeDefinition::getName);
        }
        if (definition instanceof InputObjectTypeExtensionDefinition) {
            InputObjectTypeExtensionDefinition newEntry = (InputObjectTypeExtensionDefinition)definition;
            return this.defineExt(this.inputObjectTypeExtensions, newEntry, InputObjectTypeDefinition::getName);
        }
        if (definition instanceof SchemaExtensionDefinition) {
            this.schemaExtensionDefinitions.add((SchemaExtensionDefinition)definition);
            this.schemaParseOrder.addDefinition(definition);
            Optional<GraphQLError> error = this.checkAddOperationDefs();
            if (error.isPresent()) {
                return error;
            }
        } else {
            if (definition instanceof ScalarTypeDefinition) {
                ScalarTypeDefinition newEntry = (ScalarTypeDefinition)definition;
                return this.define(this.scalarTypes, this.scalarTypes, newEntry);
            }
            if (definition instanceof TypeDefinition) {
                TypeDefinition newEntry = (TypeDefinition)definition;
                return this.define(this.types, this.types, newEntry);
            }
            if (definition instanceof DirectiveDefinition) {
                DirectiveDefinition newEntry = (DirectiveDefinition)definition;
                return this.define(this.directiveDefinitions, this.directiveDefinitions, newEntry);
            }
            if (definition instanceof SchemaDefinition) {
                SchemaDefinition newSchema = (SchemaDefinition)definition;
                if (this.schema != null) {
                    return Optional.of(new SchemaRedefinitionError(this.schema, newSchema));
                }
                this.schema = newSchema;
                this.schemaParseOrder.addDefinition(newSchema);
                Optional<GraphQLError> error = this.checkAddOperationDefs();
                if (error.isPresent()) {
                    return error;
                }
            } else {
                return (Optional)Assert.assertShouldNeverHappen();
            }
        }
        return Optional.empty();
    }

    public void remove(SDLDefinition definition) {
        Assert.assertNotNull(definition, () -> "definition to remove can't be null");
        this.schemaParseOrder.removeDefinition(definition);
        if (definition instanceof ObjectTypeExtensionDefinition) {
            this.removeFromList(this.objectTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof InterfaceTypeExtensionDefinition) {
            this.removeFromList(this.interfaceTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof UnionTypeExtensionDefinition) {
            this.removeFromList(this.unionTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof EnumTypeExtensionDefinition) {
            this.removeFromList(this.enumTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof ScalarTypeExtensionDefinition) {
            this.removeFromList(this.scalarTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof InputObjectTypeExtensionDefinition) {
            this.removeFromList(this.inputObjectTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof ScalarTypeDefinition) {
            this.scalarTypes.remove(((ScalarTypeDefinition)definition).getName());
        } else if (definition instanceof TypeDefinition) {
            this.types.remove(((TypeDefinition)definition).getName());
        } else if (definition instanceof DirectiveDefinition) {
            this.directiveDefinitions.remove(((DirectiveDefinition)definition).getName());
        } else if (definition instanceof SchemaExtensionDefinition) {
            this.schemaExtensionDefinitions.remove(definition);
        } else if (definition instanceof SchemaDefinition) {
            this.schema = null;
        } else {
            Assert.assertShouldNeverHappen();
        }
    }

    private void removeFromList(Map source, TypeDefinition value) {
        List list = (List)source.get(value.getName());
        if (list == null) {
            return;
        }
        list.remove(value);
        if (list.isEmpty()) {
            source.remove(value.getName());
        }
    }

    public void remove(String key, SDLDefinition definition) {
        Assert.assertNotNull(definition, () -> "definition to remove can't be null");
        Assert.assertNotNull(key, () -> "key to remove can't be null");
        this.schemaParseOrder.removeDefinition(definition);
        if (definition instanceof ObjectTypeExtensionDefinition) {
            this.removeFromMap(this.objectTypeExtensions, key);
        } else if (definition instanceof InterfaceTypeExtensionDefinition) {
            this.removeFromMap(this.interfaceTypeExtensions, key);
        } else if (definition instanceof UnionTypeExtensionDefinition) {
            this.removeFromMap(this.unionTypeExtensions, key);
        } else if (definition instanceof EnumTypeExtensionDefinition) {
            this.removeFromMap(this.enumTypeExtensions, key);
        } else if (definition instanceof ScalarTypeExtensionDefinition) {
            this.removeFromMap(this.scalarTypeExtensions, key);
        } else if (definition instanceof InputObjectTypeExtensionDefinition) {
            this.removeFromMap(this.inputObjectTypeExtensions, key);
        } else if (definition instanceof ScalarTypeDefinition) {
            this.removeFromMap(this.scalarTypes, key);
        } else if (definition instanceof TypeDefinition) {
            this.removeFromMap(this.types, key);
        } else if (definition instanceof DirectiveDefinition) {
            this.removeFromMap(this.directiveDefinitions, key);
        } else if (definition instanceof SchemaExtensionDefinition) {
            this.schemaExtensionDefinitions.remove(definition);
        } else if (definition instanceof SchemaDefinition) {
            this.schema = null;
        } else {
            Assert.assertShouldNeverHappen();
        }
    }

    private void removeFromMap(Map source, String key) {
        if (source == null) {
            return;
        }
        source.remove(key);
    }

    private <T extends TypeDefinition> Optional<GraphQLError> define(Map<String, T> source, Map<String, T> target, T newEntry) {
        String name = newEntry.getName();
        TypeDefinition olderEntry = (TypeDefinition)source.get(name);
        if (olderEntry != null) {
            return Optional.of(this.handleReDefinition(olderEntry, newEntry));
        }
        target.put(name, newEntry);
        this.schemaParseOrder.addDefinition(newEntry);
        return Optional.empty();
    }

    private <T extends DirectiveDefinition> Optional<GraphQLError> define(Map<String, T> source, Map<String, T> target, T newEntry) {
        String name = newEntry.getName();
        DirectiveDefinition olderEntry = (DirectiveDefinition)source.get(name);
        if (olderEntry != null) {
            return Optional.of(this.handleReDefinition(olderEntry, newEntry));
        }
        target.put(name, newEntry);
        this.schemaParseOrder.addDefinition(newEntry);
        return Optional.empty();
    }

    private <T extends TypeDefinition> Optional<GraphQLError> defineExt(Map<String, List<T>> typeExtensions, T newEntry, Function<T, String> namerFunc) {
        List currentList = typeExtensions.computeIfAbsent(namerFunc.apply(newEntry), k -> new ArrayList());
        currentList.add(newEntry);
        this.schemaParseOrder.addDefinition(newEntry);
        return Optional.empty();
    }

    public Map<String, TypeDefinition> types() {
        return new LinkedHashMap<String, TypeDefinition>(this.types);
    }

    public Map<String, ScalarTypeDefinition> scalars() {
        LinkedHashMap<String, ScalarTypeDefinition> scalars = new LinkedHashMap<String, ScalarTypeDefinition>(ScalarInfo.GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS);
        scalars.putAll(this.scalarTypes);
        return scalars;
    }

    public Map<String, List<ObjectTypeExtensionDefinition>> objectTypeExtensions() {
        return new LinkedHashMap<String, List<ObjectTypeExtensionDefinition>>(this.objectTypeExtensions);
    }

    public Map<String, List<InterfaceTypeExtensionDefinition>> interfaceTypeExtensions() {
        return new LinkedHashMap<String, List<InterfaceTypeExtensionDefinition>>(this.interfaceTypeExtensions);
    }

    public Map<String, List<UnionTypeExtensionDefinition>> unionTypeExtensions() {
        return new LinkedHashMap<String, List<UnionTypeExtensionDefinition>>(this.unionTypeExtensions);
    }

    public Map<String, List<EnumTypeExtensionDefinition>> enumTypeExtensions() {
        return new LinkedHashMap<String, List<EnumTypeExtensionDefinition>>(this.enumTypeExtensions);
    }

    public Map<String, List<ScalarTypeExtensionDefinition>> scalarTypeExtensions() {
        return new LinkedHashMap<String, List<ScalarTypeExtensionDefinition>>(this.scalarTypeExtensions);
    }

    public Map<String, List<InputObjectTypeExtensionDefinition>> inputObjectTypeExtensions() {
        return new LinkedHashMap<String, List<InputObjectTypeExtensionDefinition>>(this.inputObjectTypeExtensions);
    }

    public Optional<SchemaDefinition> schemaDefinition() {
        return Optional.ofNullable(this.schema);
    }

    public List<SchemaExtensionDefinition> getSchemaExtensionDefinitions() {
        return new ArrayList<SchemaExtensionDefinition>(this.schemaExtensionDefinitions);
    }

    private GraphQLError handleReDefinition(TypeDefinition oldEntry, TypeDefinition newEntry) {
        return new TypeRedefinitionError(newEntry, oldEntry);
    }

    private GraphQLError handleReDefinition(DirectiveDefinition oldEntry, DirectiveDefinition newEntry) {
        return new DirectiveRedefinitionError(newEntry, oldEntry);
    }

    public Optional<DirectiveDefinition> getDirectiveDefinition(String directiveName) {
        return Optional.ofNullable(this.directiveDefinitions.get(directiveName));
    }

    public Map<String, DirectiveDefinition> getDirectiveDefinitions() {
        return new LinkedHashMap<String, DirectiveDefinition>(this.directiveDefinitions);
    }

    public boolean hasType(TypeName typeName) {
        String name = typeName.getName();
        return this.types.containsKey(name) || ScalarInfo.GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.containsKey(name) || this.scalarTypes.containsKey(name) || this.objectTypeExtensions.containsKey(name);
    }

    public Optional<TypeDefinition> getType(Type type) {
        String typeName = TypeInfo.typeInfo(type).getName();
        return this.getType(typeName);
    }

    public <T extends TypeDefinition> Optional<T> getType(Type type, Class<T> ofType) {
        String typeName = TypeInfo.typeInfo(type).getName();
        return this.getType(typeName, ofType);
    }

    public Optional<TypeDefinition> getType(String typeName) {
        TypeDefinition typeDefinition = this.types.get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        typeDefinition = this.scalars().get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        return Optional.empty();
    }

    public <T extends TypeDefinition> Optional<T> getType(String typeName, Class<T> ofType) {
        TypeDefinition typeDefinition;
        Optional<TypeDefinition> type = this.getType(typeName);
        if (type.isPresent() && (typeDefinition = type.get()).getClass().equals(ofType)) {
            return Optional.of(typeDefinition);
        }
        return Optional.empty();
    }

    public boolean isInterfaceOrUnion(Type type) {
        Optional<TypeDefinition> typeDefinition = this.getType(type);
        if (typeDefinition.isPresent()) {
            TypeDefinition definition = typeDefinition.get();
            return definition instanceof UnionTypeDefinition || definition instanceof InterfaceTypeDefinition;
        }
        return false;
    }

    public boolean isObjectTypeOrInterface(Type type) {
        Optional<TypeDefinition> typeDefinition = this.getType(type);
        if (typeDefinition.isPresent()) {
            TypeDefinition definition = typeDefinition.get();
            return definition instanceof ObjectTypeDefinition || definition instanceof InterfaceTypeDefinition;
        }
        return false;
    }

    public boolean isObjectType(Type type) {
        return this.getType(type, ObjectTypeDefinition.class).isPresent();
    }

    public <T extends TypeDefinition> List<T> getTypes(Class<T> targetClass) {
        return this.types.values().stream().filter(targetClass::isInstance).map(targetClass::cast).collect(Collectors.toList());
    }

    public <T extends TypeDefinition> Map<String, T> getTypesMap(Class<T> targetClass) {
        List<T> list = this.getTypes(targetClass);
        return FpKit.getByName(list, NamedNode::getName, FpKit.mergeFirst());
    }

    public List<ImplementingTypeDefinition> getAllImplementationsOf(InterfaceTypeDefinition targetInterface) {
        List<ImplementingTypeDefinition> typeDefinitions = this.getTypes(ImplementingTypeDefinition.class);
        return typeDefinitions.stream().filter(typeDefinition -> {
            List<Type> implementsList = typeDefinition.getImplements();
            for (Type iFace : implementsList) {
                boolean equals;
                Optional<InterfaceTypeDefinition> interfaceTypeDef = this.getType(iFace, InterfaceTypeDefinition.class);
                if (!interfaceTypeDef.isPresent() || !(equals = interfaceTypeDef.get().getName().equals(targetInterface.getName()))) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public List<ObjectTypeDefinition> getImplementationsOf(InterfaceTypeDefinition targetInterface) {
        return this.getAllImplementationsOf(targetInterface).stream().filter(typeDefinition -> typeDefinition instanceof ObjectTypeDefinition).map(typeDefinition -> (ObjectTypeDefinition)typeDefinition).collect(Collectors.toList());
    }

    public boolean isPossibleType(Type abstractType, Type possibleType) {
        if (!this.isInterfaceOrUnion(abstractType)) {
            return false;
        }
        if (!this.isObjectTypeOrInterface(possibleType)) {
            return false;
        }
        TypeDefinition targetObjectTypeDef = this.getType(possibleType).get();
        TypeDefinition abstractTypeDef = this.getType(abstractType).get();
        if (abstractTypeDef instanceof UnionTypeDefinition) {
            List<Type> memberTypes = ((UnionTypeDefinition)abstractTypeDef).getMemberTypes();
            for (Type memberType : memberTypes) {
                Optional<ObjectTypeDefinition> checkType = this.getType(memberType, ObjectTypeDefinition.class);
                if (!checkType.isPresent() || !checkType.get().getName().equals(targetObjectTypeDef.getName())) continue;
                return true;
            }
            return false;
        }
        InterfaceTypeDefinition iFace = (InterfaceTypeDefinition)abstractTypeDef;
        List<ImplementingTypeDefinition> implementingTypeDefinitions = this.getAllImplementationsOf(iFace);
        return implementingTypeDefinitions.stream().anyMatch(od -> od.getName().equals(targetObjectTypeDef.getName()));
    }

    public boolean isSubTypeOf(Type maybeSubType, Type superType) {
        TypeInfo superTypeInfo;
        TypeInfo maybeSubTypeInfo = TypeInfo.typeInfo(maybeSubType);
        if (maybeSubTypeInfo.equals(superTypeInfo = TypeInfo.typeInfo(superType))) {
            return true;
        }
        if (superTypeInfo.isNonNull()) {
            if (maybeSubTypeInfo.isNonNull()) {
                return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superTypeInfo.unwrapOneType());
            }
            return false;
        }
        if (maybeSubTypeInfo.isNonNull()) {
            return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superType);
        }
        if (superTypeInfo.isList()) {
            if (maybeSubTypeInfo.isList()) {
                return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superTypeInfo.unwrapOneType());
            }
            return false;
        }
        if (maybeSubTypeInfo.isList()) {
            return false;
        }
        return this.isInterfaceOrUnion(superType) && this.isObjectTypeOrInterface(maybeSubType) && this.isPossibleType(superType, maybeSubType);
    }
}

