/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.versions;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.online.GoodVersions;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.online.LastGoodVersions;
import io.github.bonigarcia.wdm.online.Parser;
import io.github.bonigarcia.wdm.versions.Shell;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class VersionDetector {
    static final String ONLINE = "online";
    static final String LOCAL = "local";
    static final String COMMANDS_PROPERTIES = "commands.properties";
    static final String FILE_PROTOCOL = "file";
    static final String CFT_URL = "https://googlechromelabs.github.io/chrome-for-testing/";
    static final int MIN_CHROMEDRIVER_IN_CFT = 115;
    static final String VERSION_DETECTION_REGEX = "[^\\d^\\.]";
    static final String WMIC = "wmic";
    static final String POWERSHELL = "powershell";
    static final String REG_QUERY = "reg query";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    HttpClient httpClient;
    Map<String, Properties> propertiesMap;
    boolean isSnap;

    public VersionDetector(Config config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.propertiesMap = new HashMap<String, Properties>();
    }

    public String getValueFromProperties(Properties properties, String key) {
        String keyWithOs = key + "." + this.config.getOperatingSystem().getName();
        return Optional.ofNullable(properties.getProperty(keyWithOs)).orElse(properties.getProperty(key));
    }

    public Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion, URL driverUrl, Charset versionCharset, String driverName, String versionLabel, String latestLabel, Optional<String> optOsLabel) {
        Optional<String> result;
        String url2;
        block9: {
            if (driverName.equalsIgnoreCase("chromedriver")) {
                String cftUrl = null;
                try {
                    if (driverVersion.isPresent() && VersionDetector.isCfT(driverVersion.get())) {
                        cftUrl = this.config.getChromeGoodVersionsUrl();
                        GoodVersions versions = Parser.parseJson(this.httpClient, cftUrl, GoodVersions.class);
                        List fileteredList = versions.versions.stream().filter(v -> v.version.startsWith((String)driverVersion.get())).collect(Collectors.toList());
                        return Optional.of(((GoodVersions.Versions)fileteredList.get((int)(fileteredList.size() - 1))).version);
                    }
                    if (!driverVersion.isPresent()) {
                        cftUrl = this.config.getChromeLastGoodVersionsUrl();
                        LastGoodVersions versions = Parser.parseJson(this.httpClient, cftUrl, LastGoodVersions.class);
                        return Optional.of(versions.channels.stable.version);
                    }
                }
                catch (Exception e) {
                    this.log.warn("Exception reading CfT URL ('{}') to get version of {} ({})", cftUrl, driverName, e.getMessage());
                    try {
                        driverUrl = new URL(CFT_URL);
                    }
                    catch (MalformedURLException e1) {
                        this.log.error("Exception creating CfT URL {}: {}", (Object)CFT_URL, (Object)e.getMessage());
                    }
                    if (driverVersion.isPresent()) break block9;
                    versionLabel = versionLabel + "_STABLE";
                }
            }
        }
        String osLabel = optOsLabel.isPresent() ? optOsLabel.get() : "";
        String string = url2 = driverVersion.isPresent() ? driverUrl + latestLabel + "_" + driverVersion.get() + osLabel : driverUrl + versionLabel;
        if (!driverVersion.isPresent() && driverName.equalsIgnoreCase("msedgedriver") && (result = this.readUrlContent(url2, driverName, versionCharset)).isPresent()) {
            url2 = driverUrl + latestLabel + "_" + VersionDetector.getMajorVersion(result.get()) + osLabel;
        }
        if ((result = this.readUrlContent(url2, driverName, versionCharset)).isPresent()) {
            this.log.debug("Latest version of {} according to {} is {}", driverName, url2, result.get());
        }
        return result;
    }

    public Optional<String> readUrlContent(String url2, String driverName, Charset versionCharset) {
        Optional<String> result = Optional.empty();
        try (InputStream response = this.httpClient.execute(this.httpClient.createHttpGet(new URL(url2))).getEntity().getContent();){
            result = Optional.of(IOUtils.toString(response, (versionCharset != null ? versionCharset : Charset.defaultCharset()).name()).replace("\r\n", ""));
        }
        catch (Exception e) {
            this.log.warn("Exception reading {} to get latest version of {} ({})", url2, driverName, e.getMessage());
        }
        return result;
    }

    public Optional<Path> getBrowserPath(String browserName) {
        this.log.debug("Detecting {} path using the commands database", (Object)browserName);
        String pathStr = "";
        Properties commandsProperties = this.getProperties(COMMANDS_PROPERTIES, this.config.isCommandsPropertiesOnlineFirst());
        List<String> commandsPerOs = this.getCommandsList(browserName, commandsProperties);
        for (String commandKey : commandsPerOs) {
            String command = commandsProperties.get(commandKey).toString();
            int lastSpaceIndex = command.lastIndexOf(" ");
            String firstCommand = command;
            if (lastSpaceIndex != -1) {
                firstCommand = command.substring(0, lastSpaceIndex);
            }
            OperatingSystem operatingSystem = this.config.getOperatingSystem();
            switch (operatingSystem) {
                case WIN: {
                    String newCommand;
                    if (command.toLowerCase(Locale.ROOT).contains(WMIC)) {
                        newCommand = command.replace("Version", "Caption");
                        String output = this.runCommandInShell(newCommand);
                        int iCaption = output.indexOf("=");
                        if (iCaption == -1) break;
                        pathStr = output.substring(iCaption + 1);
                        break;
                    }
                    if (!command.toLowerCase(Locale.ROOT).contains(POWERSHELL)) break;
                    newCommand = command.replace("ProductVersion", "FileName");
                    pathStr = this.runCommandInShell(newCommand);
                    break;
                }
                default: {
                    if (firstCommand.contains("/")) {
                        pathStr = firstCommand;
                        break;
                    }
                    String[] commandArray = new String[]{"bash", "-c", "type -p " + firstCommand};
                    pathStr = Shell.runAndWait(this.config.getTimeout(), commandArray);
                }
            }
            try {
                Path path = Paths.get(pathStr, new String[0]);
                if (Config.isNullOrEmpty(pathStr) || !Files.exists(path, new LinkOption[0])) continue;
                this.log.debug("The path of {} is {}", (Object)browserName, (Object)pathStr);
                return Optional.of(path);
            }
            catch (Exception e) {
                this.log.trace("Invalid path {}", (Object)pathStr);
            }
        }
        this.log.info("Browser {} is not available in the system", (Object)browserName);
        return Optional.empty();
    }

    public Optional<String> getBrowserVersionFromTheShell(String browserName, String browserBinary) {
        Optional<String> browserVersionUsingProperties = Optional.empty();
        String browserVersionDetectionCommand = this.config.getBrowserVersionDetectionCommand();
        if (!Config.isNullOrEmpty(browserVersionDetectionCommand)) {
            browserVersionUsingProperties = this.getBrowserVersionUsingCommand(browserVersionDetectionCommand);
        }
        if (browserVersionUsingProperties.isPresent()) {
            return browserVersionUsingProperties;
        }
        boolean online = this.config.isCommandsPropertiesOnlineFirst();
        String propertiesName = COMMANDS_PROPERTIES;
        Properties commandsProperties = this.getProperties(propertiesName, online);
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.debug("Detecting {} version using {} {}", browserName, onlineMessage, propertiesName);
        browserVersionUsingProperties = this.getBrowserVersionUsingProperties(browserName, browserBinary, commandsProperties);
        if (!browserVersionUsingProperties.isPresent()) {
            String notOnlineMessage = online ? LOCAL : ONLINE;
            this.log.debug("Browser version for {} not detected using {} properties (using {} {})", browserName, onlineMessage, notOnlineMessage, propertiesName);
            commandsProperties = this.getProperties(propertiesName, !online);
            browserVersionUsingProperties = this.getBrowserVersionUsingProperties(browserName, browserBinary, commandsProperties);
        }
        return browserVersionUsingProperties;
    }

    protected Optional<String> getBrowserVersionUsingProperties(String browserName, String browserBinary, Properties commandsProperties) {
        List<String> commandsPerOs = this.getCommandsList(browserName, commandsProperties);
        if (!Config.isNullOrEmpty(browserBinary)) {
            String commandKey = commandsPerOs.get(0);
            String command = commandsProperties.get(commandKey).toString();
            OperatingSystem operatingSystem = this.config.getOperatingSystem();
            command = operatingSystem == OperatingSystem.WIN ? command.replaceAll("\"[^\"]*\"", "\"" + browserBinary.replace("\\", "\\\\") + "\"") : browserBinary + command.substring(command.lastIndexOf(" "));
            return this.getBrowserVersionUsingCommand(command);
        }
        for (String commandKey : commandsPerOs) {
            String command = commandsProperties.get(commandKey).toString();
            Optional<String> browserVersionUsingCommand = this.getBrowserVersionUsingCommand(command);
            if (!browserVersionUsingCommand.isPresent()) continue;
            return browserVersionUsingCommand;
        }
        return Optional.empty();
    }

    protected List<String> getCommandsList(String browserName, Properties commandsProperties) {
        Enumeration<Object> keys2 = commandsProperties.keys();
        OperatingSystem operatingSystem = this.config.getOperatingSystem();
        List<String> commandsList = Collections.list(keys2).stream().map(Object::toString).filter(s2 -> s2.contains(browserName)).filter(operatingSystem::matchOs).sorted().collect(Collectors.toList());
        if (operatingSystem.isWin()) {
            Collections.reverse(commandsList);
        }
        return commandsList;
    }

    protected String runCommandInShell(String command) {
        String output;
        String[] commandArray;
        String commandLowerCase = command.toLowerCase(Locale.ROOT);
        boolean isWmic = commandLowerCase.contains(WMIC);
        boolean isRegQuery = commandLowerCase.contains(REG_QUERY);
        boolean isPowerShell = commandLowerCase.contains(POWERSHELL);
        int lastSpaceIndex = command.lastIndexOf(" ");
        if (isPowerShell) {
            int firstSpaceIndex = command.indexOf(" ");
            int secondSpaceIndex = command.indexOf(" ", firstSpaceIndex + 1);
            commandArray = new String[]{command.substring(0, firstSpaceIndex), command.substring(firstSpaceIndex + 1, secondSpaceIndex), command.substring(secondSpaceIndex + 1)};
        } else {
            commandArray = !isWmic && !isRegQuery && lastSpaceIndex != -1 ? new String[]{command.substring(0, lastSpaceIndex), command.substring(lastSpaceIndex + 1)} : command.split(" ");
        }
        if (isWmic) {
            File wmicLocation = this.findFileLocation("wmic.exe");
            output = Shell.runAndWait(this.config.getTimeout(), wmicLocation, commandArray);
        } else {
            output = Shell.runAndWait(this.config.getTimeout(), commandArray);
        }
        return output;
    }

    protected Optional<String> getBrowserVersionUsingCommand(String command) {
        String browserVersionOutput = this.runCommandInShell(command);
        if (!Config.isNullOrEmpty(browserVersionOutput)) {
            if (browserVersionOutput.toLowerCase(Locale.ROOT).contains("snap")) {
                this.isSnap = true;
            }
            String parsedBrowserVersion = VersionDetector.parseVersion(browserVersionOutput);
            this.log.trace("Detected browser version is {}", (Object)parsedBrowserVersion);
            return Optional.of(VersionDetector.getMajorVersion(parsedBrowserVersion));
        }
        return Optional.empty();
    }

    protected Properties getProperties(String propertiesName, boolean online) {
        if (this.propertiesMap.containsKey(propertiesName)) {
            this.log.trace("Already created {}", (Object)propertiesName);
            return this.propertiesMap.get(propertiesName);
        }
        Properties properties = null;
        try (InputStream inputStream = this.getVersionsInputStream(propertiesName, online);){
            properties = new Properties();
            properties.load(new StringReader(IOUtils.toString(inputStream, StandardCharsets.UTF_8.name()).replace("\\", "\\\\")));
            this.propertiesMap.put(propertiesName, properties);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot read " + propertiesName, e);
        }
        return properties;
    }

    protected InputStream getVersionsInputStream(String propertiesName, boolean online) throws IOException {
        InputStream inputStream;
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.trace("Reading {} {} to find out driver version", (Object)onlineMessage, (Object)propertiesName);
        try {
            inputStream = online ? this.getOnlineInputStream(propertiesName) : this.getLocalInputStream(propertiesName);
        }
        catch (Exception e) {
            String exceptionMessage = online ? LOCAL : ONLINE;
            this.log.warn("Error reading {}, using {} instead", (Object)propertiesName, (Object)exceptionMessage);
            inputStream = online ? this.getLocalInputStream(propertiesName) : this.getOnlineInputStream(propertiesName);
        }
        return inputStream;
    }

    protected InputStream getLocalInputStream(String propertiesName) {
        InputStream inputStream = Config.class.getResourceAsStream("/" + propertiesName);
        return inputStream;
    }

    protected InputStream getOnlineInputStream(String propertiesName) throws IOException {
        URL propertiesUrl = this.config.getCommandsPropertiesUrl();
        InputStream inputStream = propertiesUrl.getProtocol().equalsIgnoreCase(FILE_PROTOCOL) ? new FileInputStream(new File(propertiesUrl.getFile())) : this.httpClient.execute(this.httpClient.createHttpGet(propertiesUrl)).getEntity().getContent();
        return inputStream;
    }

    public static String getMajorVersion(String version) {
        if (version != null) {
            int i = version.indexOf(46);
            return i != -1 ? version.substring(0, i) : version;
        }
        return "0";
    }

    public static boolean isCfT(String driverVersion) {
        return Config.isNullOrEmpty(driverVersion) || Integer.parseInt(VersionDetector.getMajorVersion(driverVersion)) >= 115;
    }

    protected File findFileLocation(String filename) {
        File system32File;
        File system32Folder = new File(System.getenv("SystemRoot"), "System32");
        if (this.checkFileAndFolder(system32Folder, system32File = new File(system32Folder, filename))) {
            return system32Folder;
        }
        File wbemFolder = new File(system32Folder, "wbem");
        File wbemFile = new File(wbemFolder, filename);
        if (this.checkFileAndFolder(wbemFolder, wbemFile)) {
            return wbemFolder;
        }
        return new File(".");
    }

    protected boolean checkFileAndFolder(File folder, File file) {
        return folder.exists() && folder.isDirectory() && file.exists() && file.isFile();
    }

    public boolean isSnap() {
        return this.isSnap;
    }

    public static String parseVersion(String version) {
        return version.replaceAll(VERSION_DETECTION_REGEX, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Optional<String> getWdmVersion(Class<?> clazz) {
        Optional<String> optional;
        block22: {
            try {
                String className = clazz.getName();
                String classfileName = "/" + className.replace('.', '/') + ".class";
                URL classfileResource = clazz.getResource(classfileName);
                if (classfileResource == null) break block22;
                Path absolutePackagePath = Paths.get(classfileResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments + 2;
                for (int i = 0; i < segmentsToRemove; path = path.getParent(), ++i) {
                }
                Path pom = path.resolve("pom.xml");
                try (InputStream is2 = Files.newInputStream(pom, new OpenOption[0]);){
                    Document doc = WebDriverManager.loadXML(is2);
                    doc.getDocumentElement().normalize();
                    String version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
                    if (version != null && !(version = version.trim()).isEmpty()) {
                        Optional<String> optional2 = Optional.of(version);
                        return optional2;
                    }
                }
            }
            catch (Exception className) {
                // empty catch block
            }
        }
        try (InputStream is3222 = clazz.getResourceAsStream("/META-INF/maven/io.github.bonigarcia/webdrivermanager/pom.properties");){
            if (is3222 != null) {
                Properties p = new Properties();
                p.load(is3222);
                String version = p.getProperty("version", "").trim();
                if (!version.isEmpty()) {
                    Optional<String> optional2 = Optional.of(version);
                    return optional2;
                }
            }
        }
        catch (Exception is3222) {
            // empty catch block
        }
        String version = null;
        Package pkg = clazz.getPackage();
        if (pkg != null && (version = pkg.getImplementationVersion()) == null) {
            version = pkg.getSpecificationVersion();
        }
        String string = version = version == null ? "" : version.trim();
        if (version.isEmpty()) {
            optional = Optional.empty();
            return optional;
        }
        optional = Optional.of(version);
        return optional;
    }
}

