/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.docker.DockerContainer;
import io.github.bonigarcia.wdm.webdriver.Recording;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowser {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    WebDriver driver;
    String recordingName;
    String browserName;
    OperatingSystem os;
    List<DockerContainer> dockerContainerList;
    String browserContainerId;
    String noVncUrl;
    String vncUrl;
    String seleniumServerUrl;
    String recordingBase64;
    Path recordingPath;
    int identityHash;

    public WebDriverBrowser(String browserName, OperatingSystem os) {
        this.browserName = browserName;
        this.os = os;
        this.dockerContainerList = new ArrayList<DockerContainer>();
    }

    public WebDriverBrowser(WebDriver driver, String browserName, OperatingSystem os) {
        this.browserName = browserName;
        this.os = os;
        this.setDriver(driver);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        this.identityHash = this.calculateIdentityHash(driver);
    }

    public List<DockerContainer> getDockerContainerList() {
        return this.dockerContainerList;
    }

    public void addDockerContainer(DockerContainer dockerContainer) {
        this.dockerContainerList.add(dockerContainer);
    }

    public void addDockerContainer(DockerContainer dockerContainer, int position) {
        this.dockerContainerList.add(position, dockerContainer);
    }

    public String getBrowserContainerId() {
        return this.browserContainerId;
    }

    public void setBrowserContainerId(String browserContainerId) {
        this.browserContainerId = browserContainerId;
    }

    public URL getNoVncUrl() {
        return this.getUrl(this.noVncUrl);
    }

    public void setNoVncUrl(String noVncUrl) {
        this.noVncUrl = noVncUrl;
    }

    public String getVncUrl() {
        return this.vncUrl;
    }

    public void setVncUrl(String vncUrl) {
        this.vncUrl = vncUrl;
    }

    public URL getSeleniumServerUrl() {
        return this.getUrl(this.seleniumServerUrl);
    }

    public void setSeleniumServerUrl(String seleniumServerUrl) {
        this.seleniumServerUrl = seleniumServerUrl;
    }

    protected URL getUrl(String urlStr) {
        URL url2 = null;
        try {
            url2 = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            log.error("Exception creating URL", e);
        }
        return url2;
    }

    public Path getRecordingPath() {
        if (this.recordingBase64 != null && this.recordingPath == null) {
            try {
                byte[] videoBytes = Base64.getDecoder().decode(this.recordingBase64);
                Path path = Paths.get(this.recordingName, new String[0]);
                Files.write(path, videoBytes, new OpenOption[0]);
                this.setRecordingPath(path);
            }
            catch (Exception e) {
                log.warn("Exception stopping recording", e);
            }
        }
        return this.recordingPath;
    }

    public void setRecordingPath(Path recordingPath) {
        this.recordingPath = recordingPath;
    }

    public int getIdentityHash() {
        return this.identityHash;
    }

    public int calculateIdentityHash(Object object) {
        return System.identityHashCode(object);
    }

    public List<Map<String, Object>> readLogs() {
        return (List)this.readJavaScriptVariable("console._bwLogs");
    }

    public Object readJavaScriptVariable(String jsVariable) {
        return this.executeJavaScript("return " + jsVariable + ";");
    }

    public Object executeJavaScript(String jsCommand) {
        return ((JavascriptExecutor)((Object)this.driver)).executeScript(jsCommand, new Object[0]);
    }

    public void startRecording() {
        this.startRecording(Recording.getRecordingNameForBrowserWatcher(this.browserName, ((RemoteWebDriver)this.driver).getSessionId().toString()));
    }

    public void startRecording(String recordingName) {
        this.setRecordingName(recordingName);
        ((JavascriptExecutor)((Object)this.driver)).executeScript("window.postMessage({ type: \"startRecording\", name: \"" + recordingName + "\" }, \"*\");", new Object[0]);
    }

    public void stopRecording() {
        String script = "var callback = arguments[0];function handler(event) {    if (event.data.type === \"stopRecordingResponse\") {        window.removeEventListener(\"message\", handler);        callback(event.data.result);    }}window.addEventListener(\"message\", handler);window.postMessage({ type: \"stopRecordingBase64\" }, \"*\");";
        Map result = (Map)((JavascriptExecutor)((Object)this.driver)).executeAsyncScript(script, new Object[0]);
        this.setRecordingName((String)result.get("name"));
        this.setRecordingBase64((String)result.get("base64"));
    }

    public String getRecordingName() {
        return this.recordingName;
    }

    public void setRecordingName(String recordingName) {
        this.recordingName = recordingName;
    }

    public String getRecordingBase64() {
        String recording = WebDriverBrowser.path2Base64(this.recordingPath);
        if (recording != null) {
            this.setRecordingBase64(recording);
        }
        return this.recordingBase64;
    }

    public void setRecordingBase64(String recordingBase64) {
        this.recordingBase64 = recordingBase64;
    }

    public static String path2Base64(Path filePath) {
        try {
            if (filePath != null) {
                byte[] fileBytes = Files.readAllBytes(filePath);
                return Base64.getEncoder().encodeToString(fileBytes);
            }
        }
        catch (Exception e) {
            log.warn("Exception converting {} to Base64", (Object)filePath, (Object)e);
        }
        return null;
    }
}

