/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface LogRecordData {
    public Resource getResource();

    public InstrumentationScopeInfo getInstrumentationScopeInfo();

    public long getTimestampEpochNanos();

    public long getObservedTimestampEpochNanos();

    public SpanContext getSpanContext();

    public Severity getSeverity();

    @Nullable
    public String getSeverityText();

    @Deprecated
    public Body getBody();

    @Nullable
    default public Value<?> getBodyValue() {
        Body body2 = this.getBody();
        return body2.getType() == Body.Type.EMPTY ? null : Value.of(body2.asString());
    }

    public Attributes getAttributes();

    public int getTotalAttributeCount();

    @Nullable
    default public String getEventName() {
        return null;
    }
}

