/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.Try;
import org.dataloader.annotations.PublicSpi;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.impl.NoOpValueCache;
import org.jspecify.annotations.NullMarked;

@PublicSpi
@NullMarked
public interface ValueCache<K, V> {
    public static <K, V> ValueCache<K, V> defaultValueCache() {
        return NoOpValueCache.NOOP;
    }

    public CompletableFuture<V> get(K var1);

    default public CompletableFuture<List<Try<V>>> getValues(List<K> keys2) throws ValueCachingNotSupported {
        ArrayList cacheLookups = new ArrayList(keys2.size());
        for (K key : keys2) {
            CompletableFuture<Try<V>> cacheTry = Try.tryFuture(this.get(key));
            cacheLookups.add(cacheTry);
        }
        return CompletableFutureKit.allOf(cacheLookups);
    }

    public CompletableFuture<V> set(K var1, V var2);

    default public CompletableFuture<List<V>> setValues(List<K> keys2, List<V> values2) throws ValueCachingNotSupported {
        ArrayList cacheSets = new ArrayList(keys2.size());
        for (int i = 0; i < keys2.size(); ++i) {
            K k = keys2.get(i);
            Object v = values2.get(i);
            CompletableFuture<V> setCall = this.set(k, v);
            CompletionStage set = Try.tryFuture(setCall).thenApply(ignored -> v);
            cacheSets.add(set);
        }
        return CompletableFutureKit.allOf(cacheSets);
    }

    public CompletableFuture<Void> delete(K var1);

    public CompletableFuture<Void> clear();

    public static class ValueCachingNotSupported
    extends UnsupportedOperationException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

