/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class HttpDestination
extends ContainerLifeCycle
implements Destination,
Closeable,
Callback,
Dumpable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;
    private final RequestTimeouts requestTimeouts;
    private final Locker staleLock = new Locker();
    private ConnectionPool connectionPool;
    private boolean stale;
    private long activeNanos;

    public HttpDestination(HttpClient client, Origin origin) {
        Object tag;
        this.client = client;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(client);
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier();
        this.requestTimeouts = new RequestTimeouts(client.getScheduler());
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        ClientConnectionFactory connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
            if (this.proxy.isSecure()) {
                connectionFactory = this.newSslClientConnectionFactory(this.proxy.getSslContextFactory(), connectionFactory);
            }
        } else if (this.isSecure()) {
            connectionFactory = this.newSslClientConnectionFactory(null, connectionFactory);
        }
        if ((tag = origin.getTag()) instanceof ClientConnectionFactory.Decorator) {
            connectionFactory = ((ClientConnectionFactory.Decorator)tag).apply(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
        String host2 = HostPort.normalizeHost(this.getHost());
        if (!client.isDefaultPort(this.getScheme(), this.getPort())) {
            host2 = host2 + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, host2);
    }

    public boolean stale() {
        try (Locker.Lock l = this.staleLock.lock();){
            boolean stale = this.stale;
            if (!stale) {
                this.activeNanos = System.nanoTime();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stale check done with result {} on {}", stale, this);
            }
            boolean bl = stale;
            return bl;
        }
    }

    @Override
    public boolean sweep() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sweep check in progress on {}", this);
        }
        boolean remove = false;
        try (Locker.Lock l = this.staleLock.lock();){
            boolean stale;
            boolean bl = stale = this.exchanges.isEmpty() && this.connectionPool.isEmpty();
            if (!stale) {
                this.activeNanos = System.nanoTime();
            } else if (this.isStaleDelayExpired()) {
                this.stale = true;
                remove = true;
            }
        }
        if (remove) {
            this.getHttpClient().removeDestination(this);
            LifeCycle.stop(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sweep check done with result {} on {}", remove, this);
        }
        return remove;
    }

    private boolean isStaleDelayExpired() {
        assert (this.staleLock.isLocked());
        long destinationIdleTimeout = TimeUnit.MILLISECONDS.toNanos(this.getHttpClient().getDestinationIdleTimeout());
        return System.nanoTime() - this.activeNanos >= destinationIdleTimeout;
    }

    @Override
    protected void doStart() throws Exception {
        Sweeper destinationSweeper;
        this.connectionPool = this.newConnectionPool(this.client);
        this.addBean(this.connectionPool, true);
        super.doStart();
        Sweeper connectionPoolSweeper = this.client.getBean(Sweeper.class);
        if (connectionPoolSweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            connectionPoolSweeper.offer((Sweeper.Sweepable)((Object)this.connectionPool));
        }
        if ((destinationSweeper = this.getHttpClient().getDestinationSweeper()) != null) {
            destinationSweeper.offer(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        Sweeper connectionPoolSweeper;
        Sweeper destinationSweeper = this.getHttpClient().getDestinationSweeper();
        if (destinationSweeper != null) {
            destinationSweeper.remove(this);
        }
        if ((connectionPoolSweeper = this.client.getBean(Sweeper.class)) != null && this.connectionPool instanceof Sweeper.Sweepable) {
            connectionPoolSweeper.remove((Sweeper.Sweepable)((Object)this.connectionPool));
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return client.getTransport().getConnectionPoolFactory().newConnectionPool(this);
    }

    protected Queue<HttpExchange> newExchangeQueue(HttpClient client) {
        return new BlockingArrayQueue<HttpExchange>(client.getMaxRequestsQueuedPerDestination());
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return this.client.newSslClientConnectionFactory(null, connectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(connectionFactory);
        }
        return this.client.newSslClientConnectionFactory(sslContextFactory, connectionFactory);
    }

    public boolean isSecure() {
        return HttpClient.isSchemeSecure(this.getScheme());
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @ManagedAttribute(value="The destination scheme", readonly=true)
    public String getScheme() {
        return this.origin.getScheme();
    }

    @Override
    @ManagedAttribute(value="The destination host", readonly=true)
    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    @Override
    @ManagedAttribute(value="The destination port", readonly=true)
    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    @ManagedAttribute(value="The number of queued requests", readonly=true)
    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send(false);
    }

    @Override
    public void failed(Throwable x) {
        this.abort(x);
    }

    public void send(Request request, Response.CompleteListener listener) {
        ((HttpRequest)request).sendAsync(this, listener);
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        this.send(new HttpExchange(this, request, listeners));
    }

    public void send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        if (this.client.isRunning()) {
            if (this.enqueue(this.exchanges, exchange)) {
                this.requestTimeouts.schedule(exchange);
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    request.abort(new RejectedExecutionException(this.client + " is stopping"));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued {} for {}", request, this);
                    }
                    this.requestNotifier.notifyQueued(request);
                    this.send();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max queue size {} exceeded by {} for {}", this.client.getMaxRequestsQueuedPerDestination(), request, this);
                }
                request.abort(new RejectedExecutionException("Max requests queued per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            request.abort(new RejectedExecutionException(this.client + " is stopped"));
        }
    }

    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange exchange) {
        return queue.offer(exchange);
    }

    public void send() {
        this.send(true);
    }

    private void send(boolean create) {
        if (!this.getHttpExchanges().isEmpty()) {
            this.process(create);
        }
    }

    private void process(boolean create) {
        boolean proceed;
        Connection connection;
        while ((connection = this.connectionPool instanceof AbstractConnectionPool ? ((AbstractConnectionPool)this.connectionPool).acquire(create) : this.connectionPool.acquire()) != null && (proceed = this.process(connection))) {
            create = false;
        }
    }

    private boolean process(Connection connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            boolean released;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            if (!(released = this.connectionPool.release(connection))) {
                connection.close();
            }
            exchange.abort(cause);
            return this.getQueuedRequestCount() > 0;
        }
        SendFailure failure = this.send(connection, exchange);
        if (failure == null) {
            return this.getQueuedRequestCount() > 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send failed {} for {}", failure, exchange);
        }
        if (failure.retry) {
            this.send(exchange);
            return false;
        }
        request.abort(failure.failure);
        return this.getQueuedRequestCount() > 0;
    }

    protected abstract SendFailure send(Connection var1, HttpExchange var2);

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", this);
        }
        this.connectionPool.close();
        this.requestTimeouts.destroy();
    }

    public void release(Connection connection) {
        HttpClient client;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send(false);
                } else {
                    connection.close();
                    this.send(true);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            connection.close();
        }
    }

    public boolean remove(Connection connection) {
        boolean removed = this.connectionPool.remove(connection);
        if (removed) {
            this.send(true);
        }
        return removed;
    }

    @Deprecated
    public void close(Connection connection) {
        this.remove(connection);
    }

    public void abort(Throwable cause) {
        for (HttpExchange exchange : new ArrayList<HttpExchange>(this.exchanges)) {
            exchange.getRequest().abort(cause);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new DumpableCollection("exchanges", this.exchanges));
    }

    public String asString() {
        return this.origin.asString();
    }

    @ManagedAttribute(value="For how long this destination has been idle in ms")
    public long getIdle() {
        if (this.getHttpClient().getDestinationIdleTimeout() <= 0L) {
            return -1L;
        }
        try (Locker.Lock l = this.staleLock.lock();){
            long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.activeNanos);
            return l2;
        }
    }

    @ManagedAttribute(value="Whether this destinations is stale")
    public boolean isStale() {
        try (Locker.Lock l = this.staleLock.lock();){
            boolean bl = this.stale;
            return bl;
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x%s,state=%s,queue=%d,pool=%s,stale=%b,idle=%d", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.getState(), this.getQueuedRequestCount(), this.getConnectionPool(), this.isStale(), this.getIdle());
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpExchange> {
        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        protected Iterator<HttpExchange> iterator() {
            return HttpDestination.this.exchanges.iterator();
        }

        @Override
        protected boolean onExpired(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            request.abort(new TimeoutException("Total timeout " + request.getConversation().getTimeout() + " ms elapsed"));
            return false;
        }
    }
}

