/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.remote.http.HttpMethod;

public class ContinueRequestParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public ContinueRequestParameters(String request) {
        this.map.put("request", request);
    }

    public ContinueRequestParameters body(BytesValue value) {
        this.map.put("body", value.toMap());
        return this;
    }

    public ContinueRequestParameters cookies(List<Header> cookieHeaders) {
        List cookies = cookieHeaders.stream().map(Header::toMap).collect(Collectors.toList());
        this.map.put("cookies", cookies);
        return this;
    }

    public ContinueRequestParameters headers(List<Header> headers) {
        List headerList = headers.stream().map(Header::toMap).collect(Collectors.toList());
        this.map.put("headers", headerList);
        return this;
    }

    public ContinueRequestParameters method(HttpMethod method) {
        this.map.put("method", method.toString());
        return this;
    }

    public ContinueRequestParameters url(String url2) {
        this.map.put("url", url2);
        return this;
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

