/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.css.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v137.css.model.Value;
import org.openqa.selenium.json.JsonInput;

public class CSSPropertyRegistration {
    private final String propertyName;
    private final Optional<Value> initialValue;
    private final Boolean inherits;
    private final String syntax;

    public CSSPropertyRegistration(String propertyName, Optional<Value> initialValue, Boolean inherits, String syntax) {
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName is required");
        this.initialValue = initialValue;
        this.inherits = Objects.requireNonNull(inherits, "inherits is required");
        this.syntax = Objects.requireNonNull(syntax, "syntax is required");
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Optional<Value> getInitialValue() {
        return this.initialValue;
    }

    public Boolean getInherits() {
        return this.inherits;
    }

    public String getSyntax() {
        return this.syntax;
    }

    private static CSSPropertyRegistration fromJson(JsonInput input) {
        String propertyName = null;
        Optional<Value> initialValue = Optional.empty();
        Boolean inherits = false;
        String syntax = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "propertyName": {
                    propertyName = input.nextString();
                    continue block12;
                }
                case "initialValue": {
                    initialValue = Optional.ofNullable((Value)input.read((Type)((Object)Value.class)));
                    continue block12;
                }
                case "inherits": {
                    inherits = input.nextBoolean();
                    continue block12;
                }
                case "syntax": {
                    syntax = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSPropertyRegistration(propertyName, initialValue, inherits, syntax);
    }
}

