/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.indexeddb.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class KeyPath {
    private final Type type;
    private final Optional<String> string;
    private final Optional<List<String>> array;

    public KeyPath(Type type, Optional<String> string, Optional<List<String>> array) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.string = string;
        this.array = array;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getString() {
        return this.string;
    }

    public Optional<List<String>> getArray() {
        return this.array;
    }

    private static KeyPath fromJson(JsonInput input) {
        Type type = null;
        Optional<String> string = Optional.empty();
        Optional<List<String>> array = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block10;
                }
                case "string": {
                    string = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "array": {
                    array = Optional.ofNullable(input.readArray((java.lang.reflect.Type)((Object)String.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new KeyPath(type, string, array);
    }

    public static enum Type {
        NULL("null"),
        STRING("string"),
        ARRAY("array");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

