/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.DirectTCPSocketOptions;
import org.openqa.selenium.devtools.v138.network.model.Initiator;
import org.openqa.selenium.devtools.v138.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v138.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectTCPSocketCreated {
    private final RequestId identifier;
    private final String remoteAddr;
    private final Integer remotePort;
    private final DirectTCPSocketOptions options;
    private final MonotonicTime timestamp;
    private final Optional<Initiator> initiator;

    public DirectTCPSocketCreated(RequestId identifier, String remoteAddr, Integer remotePort, DirectTCPSocketOptions options, MonotonicTime timestamp, Optional<Initiator> initiator) {
        this.identifier = Objects.requireNonNull(identifier, "identifier is required");
        this.remoteAddr = Objects.requireNonNull(remoteAddr, "remoteAddr is required");
        this.remotePort = Objects.requireNonNull(remotePort, "remotePort is required");
        this.options = Objects.requireNonNull(options, "options is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    public RequestId getIdentifier() {
        return this.identifier;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public DirectTCPSocketOptions getOptions() {
        return this.options;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Optional<Initiator> getInitiator() {
        return this.initiator;
    }

    private static DirectTCPSocketCreated fromJson(JsonInput input) {
        RequestId identifier = null;
        String remoteAddr = null;
        Integer remotePort = 0;
        DirectTCPSocketOptions options = null;
        MonotonicTime timestamp = null;
        Optional<Initiator> initiator = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "identifier": {
                    identifier = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block16;
                }
                case "remoteAddr": {
                    remoteAddr = input.nextString();
                    continue block16;
                }
                case "remotePort": {
                    remotePort = input.nextNumber().intValue();
                    continue block16;
                }
                case "options": {
                    options = (DirectTCPSocketOptions)input.read((Type)((Object)DirectTCPSocketOptions.class));
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read((Type)((Object)MonotonicTime.class));
                    continue block16;
                }
                case "initiator": {
                    initiator = Optional.ofNullable((Initiator)input.read((Type)((Object)Initiator.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectTCPSocketCreated(identifier, remoteAddr, remotePort, options, timestamp, initiator);
    }
}

