/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.target.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RemoteLocation {
    private final String host;
    private final Integer port;

    public RemoteLocation(String host2, Integer port) {
        this.host = Objects.requireNonNull(host2, "host is required");
        this.port = Objects.requireNonNull(port, "port is required");
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    private static RemoteLocation fromJson(JsonInput input) {
        String host2 = null;
        Integer port = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "host": {
                    host2 = input.nextString();
                    continue block8;
                }
                case "port": {
                    port = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RemoteLocation(host2, port);
    }
}

