/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.backgroundservice;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v139.backgroundservice.model.BackgroundServiceEvent;
import org.openqa.selenium.devtools.v139.backgroundservice.model.RecordingStateChanged;
import org.openqa.selenium.devtools.v139.backgroundservice.model.ServiceName;

@Beta
public class BackgroundService {
    public static Command<Void> startObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command<Void>("BackgroundService.startObserving", Map.copyOf(params));
    }

    public static Command<Void> stopObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command<Void>("BackgroundService.stopObserving", Map.copyOf(params));
    }

    public static Command<Void> setRecording(Boolean shouldRecord, ServiceName service) {
        Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("shouldRecord", shouldRecord);
        params.put("service", (Object)service);
        return new Command<Void>("BackgroundService.setRecording", Map.copyOf(params));
    }

    public static Command<Void> clearEvents(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        LinkedHashMap<String, ServiceName> params = new LinkedHashMap<String, ServiceName>();
        params.put("service", service);
        return new Command<Void>("BackgroundService.clearEvents", Map.copyOf(params));
    }

    public static Event<RecordingStateChanged> recordingStateChanged() {
        return new Event<RecordingStateChanged>("BackgroundService.recordingStateChanged", input -> (RecordingStateChanged)input.read((Type)((Object)RecordingStateChanged.class)));
    }

    public static Event<BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event<BackgroundServiceEvent>("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map("backgroundServiceEvent", BackgroundServiceEvent.class));
    }
}

