/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.emulation.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum SensorType {
    ABSOLUTE_ORIENTATION("absolute-orientation"),
    ACCELEROMETER("accelerometer"),
    AMBIENT_LIGHT("ambient-light"),
    GRAVITY("gravity"),
    GYROSCOPE("gyroscope"),
    LINEAR_ACCELERATION("linear-acceleration"),
    MAGNETOMETER("magnetometer"),
    RELATIVE_ORIENTATION("relative-orientation");

    private String value;

    private SensorType(String value) {
        this.value = value;
    }

    public static SensorType fromString(String s2) {
        return Arrays.stream(SensorType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SensorType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SensorType fromJson(JsonInput input) {
        return SensorType.fromString(input.nextString());
    }
}

