/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.io;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v139.io.model.StreamHandle;
import org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId;
import org.openqa.selenium.json.JsonInput;

public class IO {
    public static Command<Void> close(StreamHandle handle2) {
        Objects.requireNonNull(handle2, "handle is required");
        LinkedHashMap<String, StreamHandle> params = new LinkedHashMap<String, StreamHandle>();
        params.put("handle", handle2);
        return new Command<Void>("IO.close", Map.copyOf(params));
    }

    public static Command<ReadResponse> read(StreamHandle handle2, Optional<Integer> offset, Optional<Integer> size) {
        Objects.requireNonNull(handle2, "handle is required");
        LinkedHashMap<String, StreamHandle> params = new LinkedHashMap<String, StreamHandle>();
        params.put("handle", handle2);
        offset.ifPresent(p -> params.put("offset", (StreamHandle)p));
        size.ifPresent(p -> params.put("size", (StreamHandle)p));
        return new Command<ReadResponse>("IO.read", Map.copyOf(params), input -> (ReadResponse)input.read((Type)((Object)ReadResponse.class)));
    }

    public static Command<String> resolveBlob(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        return new Command<String>("IO.resolveBlob", Map.copyOf(params), ConverterFunctions.map("uuid", String.class));
    }

    public static class ReadResponse {
        private final Optional<Boolean> base64Encoded;
        private final String data;
        private final Boolean eof;

        public ReadResponse(Optional<Boolean> base64Encoded, String data, Boolean eof) {
            this.base64Encoded = base64Encoded;
            this.data = Objects.requireNonNull(data, "data is required");
            this.eof = Objects.requireNonNull(eof, "eof is required");
        }

        public Optional<Boolean> getBase64Encoded() {
            return this.base64Encoded;
        }

        public String getData() {
            return this.data;
        }

        public Boolean getEof() {
            return this.eof;
        }

        private static ReadResponse fromJson(JsonInput input) {
            Optional<Boolean> base64Encoded = Optional.empty();
            String data = null;
            Boolean eof = false;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "base64Encoded": {
                        base64Encoded = Optional.ofNullable(input.nextBoolean());
                        continue block10;
                    }
                    case "data": {
                        data = input.nextString();
                        continue block10;
                    }
                    case "eof": {
                        eof = input.nextBoolean();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new ReadResponse(base64Encoded, data, eof);
        }
    }
}

