/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.profiler.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v139.profiler.model.PositionTickInfo;
import org.openqa.selenium.devtools.v139.runtime.model.CallFrame;
import org.openqa.selenium.json.JsonInput;

public class ProfileNode {
    private final Integer id;
    private final CallFrame callFrame;
    private final Optional<Integer> hitCount;
    private final Optional<List<Integer>> children;
    private final Optional<String> deoptReason;
    private final Optional<List<PositionTickInfo>> positionTicks;

    public ProfileNode(Integer id, CallFrame callFrame, Optional<Integer> hitCount, Optional<List<Integer>> children, Optional<String> deoptReason, Optional<List<PositionTickInfo>> positionTicks) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.callFrame = Objects.requireNonNull(callFrame, "callFrame is required");
        this.hitCount = hitCount;
        this.children = children;
        this.deoptReason = deoptReason;
        this.positionTicks = positionTicks;
    }

    public Integer getId() {
        return this.id;
    }

    public CallFrame getCallFrame() {
        return this.callFrame;
    }

    public Optional<Integer> getHitCount() {
        return this.hitCount;
    }

    public Optional<List<Integer>> getChildren() {
        return this.children;
    }

    public Optional<String> getDeoptReason() {
        return this.deoptReason;
    }

    public Optional<List<PositionTickInfo>> getPositionTicks() {
        return this.positionTicks;
    }

    private static ProfileNode fromJson(JsonInput input) {
        Integer id = 0;
        CallFrame callFrame = null;
        Optional<Integer> hitCount = Optional.empty();
        Optional<List<Integer>> children = Optional.empty();
        Optional<String> deoptReason = Optional.empty();
        Optional<List<PositionTickInfo>> positionTicks = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextNumber().intValue();
                    continue block16;
                }
                case "callFrame": {
                    callFrame = (CallFrame)input.read((Type)((Object)CallFrame.class));
                    continue block16;
                }
                case "hitCount": {
                    hitCount = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
                case "children": {
                    children = Optional.ofNullable(input.readArray((Type)((Object)Integer.class)));
                    continue block16;
                }
                case "deoptReason": {
                    deoptReason = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "positionTicks": {
                    positionTicks = Optional.ofNullable(input.readArray((Type)((Object)PositionTickInfo.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ProfileNode(id, callFrame, hitCount, children, deoptReason, positionTicks);
    }
}

