/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v139.storage.model.SerializedStorageKey;
import org.openqa.selenium.json.JsonInput;

public class StorageBucket {
    private final SerializedStorageKey storageKey;
    private final Optional<String> name;

    public StorageBucket(SerializedStorageKey storageKey, Optional<String> name) {
        this.storageKey = Objects.requireNonNull(storageKey, "storageKey is required");
        this.name = name;
    }

    public SerializedStorageKey getStorageKey() {
        return this.storageKey;
    }

    public Optional<String> getName() {
        return this.name;
    }

    private static StorageBucket fromJson(JsonInput input) {
        SerializedStorageKey storageKey = null;
        Optional<String> name = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "storageKey": {
                    storageKey = (SerializedStorageKey)input.read((Type)((Object)SerializedStorageKey.class));
                    continue block8;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StorageBucket(storageKey, name);
    }
}

