/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Bootstrap {
    private static final String MAIN_CLASS = Bootstrap.class.getPackage().getName() + ".Main";
    private static final Logger LOG = Logger.getLogger(Bootstrap.class.getName());

    public static void main(String[] args2) {
        ClassLoader classLoader = Bootstrap.class.getClassLoader();
        if (args2.length == 0) {
            Bootstrap.runMain(classLoader, args2);
            return;
        }
        if ("--ext".equals(args2[0])) {
            if (args2.length < 2) {
                Bootstrap.runMain(classLoader, args2);
                return;
            }
            ClassLoader parent = Bootstrap.createExtendedClassLoader(args2[1]);
            String[] remainingArgs = new String[args2.length - 2];
            System.arraycopy(args2, 2, remainingArgs, 0, args2.length - 2);
            args2 = remainingArgs;
            classLoader = new PossessiveClassLoader(parent);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        Bootstrap.runMain(classLoader, args2);
    }

    private static void runMain(ClassLoader loader, String[] args2) {
        try {
            Class<?> clazz = loader.loadClass(MAIN_CLASS);
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args2});
        }
        catch (ReflectiveOperationException e) {
            LOG.log(Level.SEVERE, "Error during execution", e);
            System.exit(1);
        }
    }

    private static ClassLoader createExtendedClassLoader(String ext) {
        ArrayList<File> jars = new ArrayList<File>();
        for (String part : ext.split(File.pathSeparator)) {
            File file2 = new File(part);
            if (!file2.exists()) {
                LOG.warning("Extension file or directory does not exist: " + String.valueOf(file2));
                continue;
            }
            if (file2.isDirectory()) {
                File[] files = file2.listFiles();
                if (files == null) {
                    LOG.warning("Cannot list files in directory: " + String.valueOf(file2));
                    continue;
                }
                for (File subdirFile : files) {
                    if (!subdirFile.isFile() || !subdirFile.getName().endsWith(".jar")) continue;
                    jars.add(subdirFile);
                }
                continue;
            }
            jars.add(file2);
        }
        URL[] jarUrls = (URL[])jars.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.log(Level.SEVERE, "Unable to find JAR file " + String.valueOf(file), e);
                throw new UncheckedIOException(e);
            }
        }).toArray(URL[]::new);
        return AccessController.doPrivileged(() -> new URLClassLoader(jarUrls, Bootstrap.class.getClassLoader()));
    }

    private static class PossessiveClassLoader
    extends ClassLoader {
        private final ClassLoader delegate;
        private final Set<String> blessed;

        PossessiveClassLoader(ClassLoader delegate) {
            super(delegate);
            this.delegate = delegate;
            this.blessed = new HashSet<String>();
            this.blessed.add("java.");
            this.blessed.add("javax.");
            this.blessed.add("sun.");
            this.blessed.add("jdk.");
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            for (String prefix : this.blessed) {
                if (!name.startsWith(prefix)) continue;
                return super.loadClass(name, resolve);
            }
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            URL resource = this.delegate.getResource(name.replaceAll("\\.", "/") + ".class");
            if (resource == null) {
                throw new ClassNotFoundException("Unable to find " + name);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (InputStream is = resource.openStream();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                int read;
                byte[] bytes = new byte[4096];
                while ((read = bis.read(bytes, 0, bytes.length)) != -1) {
                    bos.write(bytes, 0, read);
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Could not load " + name, e);
            }
            byte[] rawClass = bos.toByteArray();
            Class<?> defined = this.defineClass(name, rawClass, 0, rawClass.length);
            if (resolve) {
                this.resolveClass(defined);
            }
            return defined;
        }
    }
}

