/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public abstract class TemplateGridServerCommand
extends TemplateGridCommand {
    private static final String GRAPHQL = "/graphql";

    public Server<?> asServer(Config initialConfig) {
        Require.nonNull("Config", initialConfig);
        MemoizedConfig config = new MemoizedConfig(new CompoundConfig(initialConfig, this.getDefaultConfig()));
        final Handlers handler = this.createHandlers(config);
        return new NettyServer(new BaseServerOptions(config), handler.httpHandler, handler.websocketHandler){

            @Override
            public void stop() {
                try {
                    handler.close();
                }
                finally {
                    super.stop();
                }
            }
        };
    }

    protected static Routable graphqlRoute(String prefix, Supplier<HttpHandler> handler) {
        Routable optionsRoute = TemplateGridServerCommand.buildRoute(GRAPHQL, prefix, path -> Route.options(path).to(handler));
        Routable postRoute = TemplateGridServerCommand.buildRoute(GRAPHQL, prefix, path -> Route.post(path).to(handler));
        return Route.combine(optionsRoute, postRoute);
    }

    protected static Routable hubRoute(String prefix, Route route) {
        return TemplateGridServerCommand.buildRoute("/wd/hub", prefix, path -> Route.prefix(path).to(route));
    }

    private static Routable buildRoute(String url2, String prefix, Function<String, Route> mapper) {
        List<String> subPaths = prefix.isEmpty() ? Collections.singletonList(url2) : Arrays.asList(prefix + url2, url2);
        return subPaths.stream().map(mapper).reduce((x$0, xva$1) -> Route.combine(x$0, xva$1)).get();
    }

    protected static Routable baseRoute(String prefix, Route route) {
        if (prefix.isEmpty()) {
            return route;
        }
        return Route.combine(route, Route.prefix(prefix).to(route));
    }

    protected abstract Handlers createHandlers(Config var1);

    public static abstract class Handlers
    implements Closeable {
        public final HttpHandler httpHandler;
        public final BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler;

        public Handlers(HttpHandler http, BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler) {
            this.httpHandler = Require.nonNull("HTTP handler", http);
            this.websocketHandler = websocketHandler == null ? (str, sink) -> Optional.empty() : websocketHandler;
        }

        @Override
        public abstract void close();
    }
}

