/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.httpd.DefaultDistributorConfig;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

@AutoService(value={CliCommand.class})
public class DistributorServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(DistributorServer.class.getName());

    @Override
    public String getName() {
        return "distributor";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the distributor in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of(StandardGridRoles.DISTRIBUTOR_ROLE, StandardGridRoles.EVENT_BUS_ROLE, StandardGridRoles.HTTPD_ROLE, StandardGridRoles.SESSION_MAP_ROLE, StandardGridRoles.SESSION_QUEUE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "distributor";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultDistributorConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        DistributorOptions distributorOptions = new DistributorOptions(config);
        final Distributor distributor = distributorOptions.getDistributor();
        HttpHandler readinessCheck = req -> {
            boolean ready = distributor.isReady();
            return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(ready ? 200 : 503).setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString())).setContent(Contents.utf8String("Distributor is " + ready));
        };
        return new TemplateGridServerCommand.Handlers(Route.combine(distributor, Route.matching(req -> HttpMethod.GET.equals((Object)req.getMethod()) && "/status".equals(req.getUri())).to(() -> req -> (HttpResponse)new HttpResponse().setContent(Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("ready", true, "message", "Distributor is ready"))))), Route.get("/readyz").to(() -> readinessCheck)), null){

            @Override
            public void close() {
                if (distributor instanceof Closeable) {
                    try {
                        ((Closeable)((Object)distributor)).close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        };
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull("Config", config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Server server = (Server)this.asServer(config).start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium Distributor %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

