/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.graphql.Slot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Session {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.systemDefault());
    private final String id;
    private final Capabilities capabilities;
    private final Instant startTime;
    private final URI uri;
    private final String nodeId;
    private final URI nodeUri;
    private final org.openqa.selenium.grid.data.Slot slot;
    private static final Json JSON = new Json();

    public Session(String id, Capabilities capabilities, Instant startTime, URI uri2, String nodeId, URI nodeUri, org.openqa.selenium.grid.data.Slot slot) {
        this.id = Require.nonNull("Session id", id);
        this.capabilities = Require.nonNull("Session capabilities", capabilities);
        this.startTime = Require.nonNull("Session Start time", startTime);
        this.uri = Require.nonNull("Session uri", uri2);
        this.nodeId = Require.nonNull("Node id", nodeId);
        this.nodeUri = Require.nonNull("Node uri", nodeUri);
        this.slot = Require.nonNull("Slot", slot);
    }

    public String getId() {
        return this.id;
    }

    public String getCapabilities() {
        return JSON.toJson(this.capabilities);
    }

    public String getStartTime() {
        return DATE_TIME_FORMATTER.format(this.startTime);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getNodeUri() {
        return this.nodeUri;
    }

    public String getSessionDurationMillis() {
        long duration = Duration.between(this.startTime, Instant.now()).toMillis();
        return String.valueOf(duration);
    }

    public Slot getSlot() {
        return new Slot(this.slot.getId().getSlotId(), this.slot.getStereotype(), this.slot.getLastStarted());
    }
}

