/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;

public abstract class BaseActiveSession
implements ActiveSession {
    private final Session session;
    private final Dialect downstream;
    private final Dialect upstream;

    protected BaseActiveSession(SessionId id, URL url2, Dialect downstream, Dialect upstream, Capabilities stereotype, Capabilities capabilities, Instant startTime) {
        URI uri2;
        try {
            uri2 = Require.nonNull("URL", url2).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.session = new Session(Require.nonNull("Session id", id), uri2, ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype)), ImmutableCapabilities.copyOf(Require.nonNull("Capabilities", capabilities)), Require.nonNull("Start time", startTime));
        this.downstream = Require.nonNull("Downstream dialect", downstream);
        this.upstream = Require.nonNull("Upstream dialect", upstream);
    }

    @Override
    public SessionId getId() {
        return this.session.getId();
    }

    @Override
    public Capabilities getStereotype() {
        return this.session.getStereotype();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.session.getCapabilities();
    }

    @Override
    public Instant getStartTime() {
        return this.session.getStartTime();
    }

    @Override
    public URI getUri() {
        return this.session.getUri();
    }

    @Override
    public Dialect getUpstreamDialect() {
        return this.upstream;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    public Session asSession() {
        return this.session;
    }
}

