/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;

public class ProxyWebsocketsIntoGrid
implements BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> {
    private static final Logger LOG = Logger.getLogger(ProxyWebsocketsIntoGrid.class.getName());
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;

    public ProxyWebsocketsIntoGrid(HttpClient.Factory clientFactory, SessionMap sessions) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.sessions = Objects.requireNonNull(sessions);
    }

    @Override
    public Optional<Consumer<Message>> apply(String uri2, Consumer<Message> downstream) {
        Require.nonNull("uri", uri2);
        Require.nonNull("downstream", downstream);
        Optional<SessionId> sessionId = HttpSessionId.getSessionId(uri2).map(SessionId::new);
        if (sessionId.isEmpty()) {
            LOG.warning("Session not found for uri " + uri2);
            return Optional.empty();
        }
        try {
            URI sessionUri = this.sessions.getUri(sessionId.get());
            HttpClient client = this.clientFactory.createClient(ClientConfig.defaultConfig().baseUri(sessionUri));
            try {
                WebSocket upstream = client.openSocket(new HttpRequest(HttpMethod.GET, uri2), new ForwardingListener(downstream));
                return Optional.of(msg -> {
                    try {
                        upstream.send((Message)msg);
                    }
                    finally {
                        if (msg instanceof CloseMessage) {
                            try {
                                client.close();
                            }
                            catch (Exception e) {
                                LOG.log(Level.WARNING, "Failed to shutdown the client of " + String.valueOf(sessionUri), e);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Connecting to upstream websocket failed", e);
                client.close();
                return Optional.empty();
            }
        }
        catch (NoSuchSessionException e) {
            LOG.warning("Attempt to connect to non-existent session: " + uri2);
            return Optional.empty();
        }
    }

    private static class ForwardingListener
    implements WebSocket.Listener {
        private final Consumer<Message> downstream;

        public ForwardingListener(Consumer<Message> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        @Override
        public void onBinary(byte[] data) {
            this.downstream.accept(new BinaryMessage(data));
        }

        @Override
        public void onClose(int code, String reason) {
            this.downstream.accept(new CloseMessage(code, reason));
        }

        @Override
        public void onText(CharSequence data) {
            this.downstream.accept(new TextMessage(data));
        }

        @Override
        public void onError(Throwable cause) {
            LOG.log(Level.WARNING, "Error proxying websocket command", cause);
        }
    }
}

