/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Platform;

@NullMarked
public class HostIdentifier {
    private static final Logger LOG = Logger.getLogger(HostIdentifier.class.getName());
    private static volatile @Nullable String hostName;
    private static volatile @Nullable String hostAddress;

    private static String resolveHostName() {
        String host2;
        block19: {
            host2 = System.getenv("HOSTNAME");
            if (host2 == null) {
                host2 = System.getenv("COMPUTERNAME");
            }
            if (host2 == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec("hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block19;
                    try (InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                         BufferedReader reader = new BufferedReader(isr);){
                        host2 = reader.readLine();
                    }
                }
                catch (InterruptedException e) {
                    LOG.log(Level.WARNING, "Failed to resolve host name", e);
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "Failed to resolve host name", e);
                }
            }
        }
        if (host2 == null) {
            try {
                host2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable e) {
                host2 = "Unknown";
                LOG.log(Level.WARNING, "Failed to resolve host name", e);
            }
        }
        return host2;
    }

    private static String resolveHostAddress() {
        String address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                Enumeration<InetAddress> addresses;
                NetworkInterface en0 = NetworkInterface.getByName("en0");
                if (en0 != null && (addresses = en0.getInetAddresses()).hasMoreElements()) {
                    address = addresses.nextElement().getHostAddress();
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Failed to resolve host address", e);
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                address = "Unknown";
                LOG.log(Level.WARNING, "Failed to resolve host address", e);
            }
        }
        return address;
    }

    public static synchronized String getHostName() {
        if (hostName == null) {
            hostName = HostIdentifier.resolveHostName();
        }
        return hostName;
    }

    public static synchronized String getHostAddress() {
        if (hostAddress == null) {
            hostAddress = HostIdentifier.resolveHostAddress();
        }
        return hostAddress;
    }
}

