/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class UrlChecker {
    private static final Logger LOG = Logger.getLogger(UrlChecker.class.getName());
    static final int CONNECT_TIMEOUT_MS = 500;
    private static final int READ_TIMEOUT_MS = 1000;
    private static final long MAX_POLL_INTERVAL_MS = 320L;
    private static final long MIN_POLL_INTERVAL_MS = 10L;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(1);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread t2 = new Thread(r, "UrlChecker-" + THREAD_COUNTER.incrementAndGet());
        t2.setDaemon(true);
        return t2;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAvailable(long timeout, TimeUnit unit, URL ... urls) throws TimeoutException {
        long start2 = System.currentTimeMillis();
        LOG.fine("Waiting for " + Arrays.toString(urls));
        try {
            Future<Void> callback = EXECUTOR.submit(() -> {
                HttpURLConnection connection = null;
                long sleepMillis = 10L;
                while (!Thread.interrupted()) {
                    for (URL url2 : urls) {
                        block7: {
                            Void void_;
                            block8: {
                                try {
                                    LOG.fine("Polling " + String.valueOf(url2));
                                    connection = this.connectToUrl(url2);
                                    if (connection.getResponseCode() != 200) break block7;
                                    void_ = null;
                                    if (connection == null) break block8;
                                }
                                catch (IOException iOException) {
                                    if (connection == null) continue;
                                    UrlChecker.consume(connection);
                                    connection.disconnect();
                                    continue;
                                    catch (Throwable throwable) {
                                        if (connection != null) {
                                            UrlChecker.consume(connection);
                                            connection.disconnect();
                                        }
                                        throw throwable;
                                    }
                                }
                                UrlChecker.consume(connection);
                                connection.disconnect();
                            }
                            return void_;
                        }
                        if (connection == null) continue;
                        UrlChecker.consume(connection);
                        connection.disconnect();
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    sleepMillis = sleepMillis >= 320L ? sleepMillis : sleepMillis * 2L;
                }
                throw new InterruptedException();
            });
            try {
                callback.get(timeout, unit);
            }
            finally {
                callback.cancel(true);
            }
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Timed out waiting for %s to be available after %d ms", Arrays.toString(urls), System.currentTimeMillis() - start2), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilUnavailable(long timeout, TimeUnit unit, URL url2) throws TimeoutException {
        long start2 = System.currentTimeMillis();
        LOG.fine("Waiting for " + String.valueOf(url2));
        try {
            Future<Void> callback = EXECUTOR.submit(() -> {
                HttpURLConnection connection = null;
                long sleepMillis = 10L;
                while (!Thread.interrupted()) {
                    block7: {
                        Void void_;
                        block8: {
                            try {
                                LOG.fine("Polling " + String.valueOf(url2));
                                connection = this.connectToUrl(url2);
                                if (connection.getResponseCode() == 200) break block7;
                                void_ = null;
                                if (connection == null) break block8;
                            }
                            catch (IOException e) {
                                Void void_2;
                                block9: {
                                    try {
                                        void_2 = null;
                                        if (connection == null) break block9;
                                    }
                                    catch (Throwable throwable) {
                                        if (connection != null) {
                                            UrlChecker.consume(connection);
                                            connection.disconnect();
                                        }
                                        throw throwable;
                                    }
                                    UrlChecker.consume(connection);
                                    connection.disconnect();
                                }
                                return void_2;
                            }
                            UrlChecker.consume(connection);
                            connection.disconnect();
                        }
                        return void_;
                    }
                    if (connection != null) {
                        UrlChecker.consume(connection);
                        connection.disconnect();
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    sleepMillis = sleepMillis >= 320L ? sleepMillis : sleepMillis * 2L;
                }
                throw new InterruptedException();
            });
            try {
                callback.get(timeout, unit);
            }
            finally {
                callback.cancel(true);
            }
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Timed out waiting for %s to become unavailable after %d ms", url2, System.currentTimeMillis() - start2), e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static void consume(HttpURLConnection connection) {
        try {
            InputStream data = connection.getErrorStream();
            if (data == null) {
                data = connection.getInputStream();
            }
            if (data != null) {
                data.readAllBytes();
                data.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpURLConnection connectToUrl(URL url2) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url2.openConnection();
        connection.setConnectTimeout(500);
        connection.setReadTimeout(1000);
        connection.connect();
        return connection;
    }

    public static class TimeoutException
    extends Exception {
        public TimeoutException(String s2, Throwable throwable) {
            super(s2, throwable);
        }
    }
}

