/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;

final class TomlSerializer {
    private TomlSerializer() {
    }

    static void toToml(TomlTable table, Appendable appendable) throws IOException {
        Objects.requireNonNull(table);
        Objects.requireNonNull(appendable);
        TomlSerializer.toToml(table, appendable, -2, "");
    }

    private static void toToml(TomlTable table, Appendable appendable, int indent, String path) throws IOException {
        List entryListSorted = table.entrySet().stream().sorted(Comparator.comparing(entry -> {
            TomlType tomlType = TomlType.typeFor(entry.getValue()).get();
            return tomlType.equals((Object)TomlType.TABLE) || tomlType.equals((Object)TomlType.ARRAY) && TomlSerializer.isTableArray((TomlArray)entry.getValue()) ? 1 : 0;
        })).collect(Collectors.toList());
        for (Map.Entry entry2 : entryListSorted) {
            boolean isTableArray;
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            if (!(key = Toml.tomlEscape(key).toString()).matches("[a-zA-Z0-9_-]*")) {
                key = "\"" + key + "\"";
            }
            String newPath = (path.isEmpty() ? "" : path + ".") + key;
            Optional<TomlType> tomlType = TomlType.typeFor(value);
            assert (tomlType.isPresent());
            boolean bl = isTableArray = tomlType.get().equals((Object)TomlType.ARRAY) && TomlSerializer.isTableArray((TomlArray)value);
            if (tomlType.get().equals((Object)TomlType.TABLE)) {
                TomlSerializer.append(appendable, indent + 2, "[" + newPath + "]");
                appendable.append(System.lineSeparator());
            } else if (!isTableArray) {
                TomlSerializer.append(appendable, indent + 2, key + "=");
            }
            TomlSerializer.appendTomlValue(value, appendable, indent, newPath);
            if (tomlType.get().equals((Object)TomlType.TABLE) || isTableArray) continue;
            appendable.append(System.lineSeparator());
        }
    }

    static void toToml(TomlArray array, Appendable appendable) throws IOException {
        Objects.requireNonNull(array);
        Objects.requireNonNull(appendable);
        TomlSerializer.toToml(array, appendable, 0, "");
    }

    private static void toToml(TomlArray array, Appendable appendable, int indent, String path) throws IOException {
        boolean tableArray = TomlSerializer.isTableArray(array);
        if (!tableArray) {
            appendable.append("[");
            if (!array.isEmpty()) {
                appendable.append(System.lineSeparator());
            }
        }
        Iterator<Object> iterator2 = array.toList().iterator();
        while (iterator2.hasNext()) {
            Object tomlValue = iterator2.next();
            Optional<TomlType> tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (tomlType.get().equals((Object)TomlType.TABLE)) {
                TomlSerializer.append(appendable, indent, "[[" + path + "]]");
                appendable.append(System.lineSeparator());
                TomlSerializer.toToml((TomlTable)tomlValue, appendable, indent, path);
            } else {
                TomlSerializer.indentLine(appendable, indent + 2);
                TomlSerializer.appendTomlValue(tomlValue, appendable, indent, path);
            }
            if (tableArray) continue;
            if (iterator2.hasNext()) {
                appendable.append(",");
            }
            appendable.append(System.lineSeparator());
        }
        if (!tableArray) {
            TomlSerializer.append(appendable, indent, "]");
        }
    }

    private static void appendTomlValue(Object value, Appendable appendable, int indent, String path) throws IOException {
        Optional<TomlType> tomlType = TomlType.typeFor(value);
        assert (tomlType.isPresent());
        switch (tomlType.get()) {
            case STRING: {
                TomlSerializer.append(appendable, 0, "\"" + Toml.tomlEscape((String)value) + "\"");
                break;
            }
            case INTEGER: 
            case FLOAT: {
                TomlSerializer.append(appendable, 0, value.toString());
                break;
            }
            case OFFSET_DATE_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)value));
                break;
            }
            case LOCAL_DATE_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)value));
                break;
            }
            case LOCAL_DATE: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)value));
                break;
            }
            case LOCAL_TIME: {
                TomlSerializer.append(appendable, 0, DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)value));
                break;
            }
            case BOOLEAN: {
                TomlSerializer.append(appendable, 0, (Boolean)value != false ? "true" : "false");
                break;
            }
            case ARRAY: {
                TomlSerializer.toToml((TomlArray)value, appendable, indent + 2, path);
                break;
            }
            case TABLE: {
                TomlSerializer.toToml((TomlTable)value, appendable, indent + 2, path);
            }
        }
    }

    private static void append(Appendable appendable, int indent, String line) throws IOException {
        TomlSerializer.indentLine(appendable, indent);
        appendable.append(line);
    }

    private static void indentLine(Appendable appendable, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            appendable.append(' ');
        }
    }

    private static boolean isTableArray(TomlArray array) {
        for (Object tomlValue : array.toList()) {
            Optional<TomlType> tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (!tomlType.get().equals((Object)TomlType.TABLE)) continue;
            return true;
        }
        return false;
    }
}

