/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.Locale;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZThread {
    private ZThread() {
    }

    public static void start(IDetachedRunnable runnable, Object ... args2) {
        ShimThread shim = new ShimThread(runnable, args2);
        shim.setDaemon(true);
        shim.start();
    }

    public static ZMQ.Socket fork(ZContext ctx, IAttachedRunnable runnable, Object ... args2) {
        ZMQ.Socket pipe = ctx.createSocket(SocketType.PAIR);
        assert (pipe != null);
        pipe.bind(String.format(Locale.ENGLISH, "inproc://zctx-pipe-%d", pipe.hashCode()));
        ZContext ccontext = ctx.shadow();
        ZMQ.Socket cpipe = ccontext.createSocket(SocketType.PAIR);
        assert (cpipe != null);
        cpipe.connect(String.format(Locale.ENGLISH, "inproc://zctx-pipe-%d", pipe.hashCode()));
        ShimThread shim = new ShimThread(ccontext, runnable, args2, cpipe);
        shim.start();
        return pipe;
    }

    private static class ShimThread
    extends Thread {
        private ZContext ctx;
        private IAttachedRunnable attachedRunnable;
        private IDetachedRunnable detachedRunnable;
        private final Object[] args;
        private ZMQ.Socket pipe;

        protected ShimThread(ZContext ctx, IAttachedRunnable runnable, Object[] args2, ZMQ.Socket pipe) {
            assert (ctx != null);
            assert (pipe != null);
            assert (runnable != null);
            this.ctx = ctx;
            this.attachedRunnable = runnable;
            this.args = args2;
            this.pipe = pipe;
            this.setUncaughtExceptionHandler(ctx.getUncaughtExceptionHandler());
        }

        public ShimThread(IDetachedRunnable runnable, Object[] args2) {
            assert (runnable != null);
            this.detachedRunnable = runnable;
            this.args = args2;
        }

        @Override
        public void run() {
            if (this.attachedRunnable != null) {
                block4: {
                    try {
                        this.attachedRunnable.run(this.args, this.ctx, this.pipe);
                    }
                    catch (ZMQException e) {
                        if (e.getErrorCode() == ZMQ.Error.ETERM.getCode()) break block4;
                        throw e;
                    }
                }
                this.ctx.destroy();
            } else {
                this.detachedRunnable.run(this.args);
            }
        }
    }

    public static interface IDetachedRunnable {
        public void run(Object[] var1);
    }

    public static interface IAttachedRunnable {
        public void run(Object[] var1, ZContext var2, ZMQ.Socket var3);
    }
}

