/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism.curve;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.curve.Curve;
import zmq.util.Errno;
import zmq.util.Wire;

public class CurveClientMechanism
extends Mechanism {
    private State state;
    private final byte[] publicKey;
    private final byte[] secretKey;
    private final byte[] cnPublic;
    private final byte[] cnSecret;
    private final byte[] serverKey;
    private final byte[] cnServer = new byte[Curve.Size.PUBLICKEY.bytes()];
    private final byte[] cnCookie = new byte[96];
    private final byte[] cnPrecom = new byte[Curve.Size.BEFORENM.bytes()];
    private long cnNonce = 1L;
    private long cnPeerNonce = 1L;
    private final Curve cryptoBox;
    private final Errno errno;

    public CurveClientMechanism(SessionBase session, Options options) {
        super(session, null, options);
        this.state = State.SEND_HELLO;
        this.publicKey = options.curvePublicKey;
        assert (this.publicKey != null && this.publicKey.length == Curve.Size.PUBLICKEY.bytes());
        this.secretKey = options.curveSecretKey;
        assert (this.secretKey != null && this.secretKey.length == Curve.Size.SECRETKEY.bytes());
        this.serverKey = options.curveServerKey;
        assert (this.serverKey != null && this.serverKey.length == Curve.Size.PUBLICKEY.bytes());
        this.cryptoBox = new Curve();
        byte[][] keys2 = this.cryptoBox.keypair();
        assert (keys2 != null && keys2.length == 2);
        this.cnPublic = keys2[0];
        assert (this.cnPublic != null && this.cnPublic.length == Curve.Size.PUBLICKEY.bytes());
        this.cnSecret = keys2[1];
        assert (this.cnSecret != null && this.cnSecret.length == Curve.Size.SECRETKEY.bytes());
        this.errno = options.errno;
    }

    @Override
    public int nextHandshakeCommand(Msg msg) {
        int rc;
        switch (this.state.ordinal()) {
            case 0: {
                rc = this.produceHello(msg);
                if (rc != 0) break;
                this.state = State.EXPECT_WELCOME;
                break;
            }
            case 2: {
                rc = this.produceInitiate(msg);
                if (rc != 0) break;
                this.state = State.EXPECT_READY;
                break;
            }
            default: {
                rc = 35;
            }
        }
        return rc;
    }

    @Override
    public int processHandshakeCommand(Msg msg) {
        int rc;
        int dataSize = msg.size();
        if (dataSize >= 8 && this.compare(msg, "WELCOME", true)) {
            rc = this.processWelcome(msg);
        } else if (dataSize >= 6 && this.compare(msg, "READY", true)) {
            rc = this.processReady(msg);
        } else if (dataSize >= 6 && this.compare(msg, "ERROR", true)) {
            rc = this.processError(msg);
        } else {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            rc = 156384820;
        }
        return rc;
    }

    @Override
    public Msg encode(Msg msg) {
        assert (this.state == State.CONNECTED);
        byte flags = 0;
        if (msg.hasMore()) {
            flags = (byte)(flags | 1);
        }
        if (msg.isCommand()) {
            flags = (byte)(flags | 2);
        }
        ByteBuffer messageNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        messageNonce.put("CurveZMQMESSAGEC".getBytes(ZMQ.CHARSET));
        Wire.putUInt64(messageNonce, this.cnNonce);
        int mlen = Curve.Size.ZERO.bytes() + 1 + msg.size();
        ByteBuffer messagePlaintext = ByteBuffer.allocate(mlen);
        messagePlaintext.put(Curve.Size.ZERO.bytes(), flags);
        messagePlaintext.position(Curve.Size.ZERO.bytes() + 1);
        msg.transfer(messagePlaintext, 0, msg.size());
        ByteBuffer messageBox = ByteBuffer.allocate(mlen);
        int rc = this.cryptoBox.afternm(messageBox, messagePlaintext, mlen, messageNonce, this.cnPrecom);
        assert (rc == 0);
        Msg encoded = new Msg(16 + mlen - Curve.Size.BOXZERO.bytes());
        encoded.putShortString("MESSAGE");
        encoded.put(messageNonce, 16, 8);
        encoded.put(messageBox, Curve.Size.BOXZERO.bytes(), mlen - Curve.Size.BOXZERO.bytes());
        ++this.cnNonce;
        return encoded;
    }

    @Override
    public Msg decode(Msg msg) {
        assert (this.state == State.CONNECTED);
        if (!this.compare(msg, "MESSAGE", true)) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            this.errno.set(156384820);
            return null;
        }
        if (msg.size() < 33) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000012);
            this.errno.set(156384820);
            return null;
        }
        ByteBuffer messageNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        messageNonce.put("CurveZMQMESSAGES".getBytes(ZMQ.CHARSET));
        msg.transfer(messageNonce, 8, 8);
        long nonce = msg.getLong(8);
        if (nonce <= this.cnPeerNonce) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            this.errno.set(156384820);
            return null;
        }
        this.cnPeerNonce = nonce;
        int clen = Curve.Size.BOXZERO.bytes() + msg.size() - 16;
        ByteBuffer messagePlaintext = ByteBuffer.allocate(clen);
        ByteBuffer messageBox = ByteBuffer.allocate(clen);
        messageBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(messageBox, 16, msg.size() - 16);
        int rc = this.cryptoBox.openAfternm(messagePlaintext, messageBox, clen, messageNonce, this.cnPrecom);
        if (rc == 0) {
            Msg decoded = new Msg(clen - 1 - Curve.Size.ZERO.bytes());
            byte flags = messagePlaintext.get(Curve.Size.ZERO.bytes());
            if ((flags & 1) != 0) {
                decoded.setFlags(1);
            }
            if ((flags & 2) != 0) {
                decoded.setFlags(2);
            }
            messagePlaintext.position(Curve.Size.ZERO.bytes() + 1);
            decoded.put(messagePlaintext);
            return decoded;
        }
        this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
        this.errno.set(156384820);
        return null;
    }

    @Override
    public Mechanism.Status status() {
        if (this.state == State.CONNECTED) {
            return Mechanism.Status.READY;
        }
        if (this.state == State.ERROR_RECEIVED) {
            return Mechanism.Status.ERROR;
        }
        return Mechanism.Status.HANDSHAKING;
    }

    @Override
    public int zapMsgAvailable() {
        return 0;
    }

    private int produceHello(Msg msg) {
        ByteBuffer helloNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer helloPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer helloBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        helloNonce.put("CurveZMQHELLO---".getBytes(ZMQ.CHARSET));
        Wire.putUInt64(helloNonce, this.cnNonce);
        int rc = this.cryptoBox.box(helloBox, helloPlaintext, helloPlaintext.capacity(), helloNonce, this.serverKey, this.cnSecret);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return -1;
        }
        msg.putShortString("HELLO");
        msg.put(1);
        msg.put(0);
        msg.put(new byte[72]);
        msg.put(this.cnPublic);
        msg.put(helloNonce, 16, 8);
        msg.put(helloBox, Curve.Size.BOXZERO.bytes(), 80);
        assert (msg.size() == 200);
        ++this.cnNonce;
        return 0;
    }

    private int processWelcome(Msg msg) {
        if (msg.size() != 168) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000016);
            return 156384820;
        }
        ByteBuffer welcomeNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer welcomePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 128);
        ByteBuffer welcomeBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 144);
        welcomeBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(welcomeBox, 24, 144);
        welcomeNonce.put("WELCOME-".getBytes(ZMQ.CHARSET));
        msg.transfer(welcomeNonce, 8, 16);
        int rc = this.cryptoBox.open(welcomePlaintext, welcomeBox, welcomeBox.capacity(), welcomeNonce, this.serverKey, this.cnSecret);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        welcomePlaintext.position(Curve.Size.ZERO.bytes());
        welcomePlaintext.get(this.cnServer);
        welcomePlaintext.get(this.cnCookie);
        rc = this.cryptoBox.beforenm(this.cnPrecom, this.cnServer, this.cnSecret);
        assert (rc == 0);
        this.state = State.SEND_INITIATE;
        return 0;
    }

    private int produceInitiate(Msg msg) {
        ByteBuffer vouchNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer vouchPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 64);
        ByteBuffer vouchBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 80);
        vouchPlaintext.position(Curve.Size.ZERO.bytes());
        vouchPlaintext.put(this.cnPublic);
        vouchPlaintext.put(this.serverKey);
        vouchNonce.put("VOUCH---".getBytes(ZMQ.CHARSET));
        vouchNonce.put(this.cryptoBox.random(16));
        int rc = this.cryptoBox.box(vouchBox, vouchPlaintext, vouchPlaintext.capacity(), vouchNonce, this.cnServer, this.secretKey);
        if (rc == -1) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return -1;
        }
        ByteBuffer initiateNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer initiatePlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 128 + 256);
        ByteBuffer initiateBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 144 + 256);
        initiatePlaintext.position(Curve.Size.ZERO.bytes());
        initiatePlaintext.put(this.publicKey);
        vouchNonce.limit(24).position(8);
        initiatePlaintext.put(vouchNonce);
        vouchBox.limit(Curve.Size.BOXZERO.bytes() + 80).position(Curve.Size.BOXZERO.bytes());
        initiatePlaintext.put(vouchBox);
        String socketType = this.socketType();
        this.addProperty(initiatePlaintext, "Socket-Type", socketType);
        if (this.options.type == 3 || this.options.type == 5 || this.options.type == 6) {
            this.addProperty(initiatePlaintext, "Identity", this.options.identity);
        }
        int mlen = initiatePlaintext.position();
        initiateNonce.put("CurveZMQINITIATE".getBytes(ZMQ.CHARSET));
        Wire.putUInt64(initiateNonce, this.cnNonce);
        rc = this.cryptoBox.box(initiateBox, initiatePlaintext, mlen, initiateNonce, this.cnServer, this.cnSecret);
        if (rc == -1) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return -1;
        }
        msg.putShortString("INITIATE");
        msg.put(this.cnCookie);
        msg.put(initiateNonce, 16, 8);
        msg.put(initiateBox, Curve.Size.BOXZERO.bytes(), mlen - Curve.Size.BOXZERO.bytes());
        assert (msg.size() == 113 + mlen - Curve.Size.BOXZERO.bytes());
        ++this.cnNonce;
        return 0;
    }

    private int processReady(Msg msg) {
        if (msg.size() < 30) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000016);
            return 156384820;
        }
        int clen = Curve.Size.BOXZERO.bytes() + msg.size() - 14;
        ByteBuffer readyNonce = ByteBuffer.allocate(Curve.Size.NONCE.bytes());
        ByteBuffer readyPlaintext = ByteBuffer.allocate(Curve.Size.ZERO.bytes() + 256);
        ByteBuffer readyBox = ByteBuffer.allocate(Curve.Size.BOXZERO.bytes() + 16 + 256);
        readyBox.position(Curve.Size.BOXZERO.bytes());
        msg.transfer(readyBox, 14, clen - Curve.Size.BOXZERO.bytes());
        readyNonce.put("CurveZMQREADY---".getBytes(ZMQ.CHARSET));
        msg.transfer(readyNonce, 6, 8);
        this.cnPeerNonce = msg.getLong(6);
        int rc = this.cryptoBox.openAfternm(readyPlaintext, readyBox, clen, readyNonce, this.cnPrecom);
        if (rc != 0) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x11000001);
            return 156384820;
        }
        readyPlaintext.limit(clen);
        rc = this.parseMetadata(readyPlaintext, Curve.Size.ZERO.bytes(), false);
        if (rc == 0) {
            this.state = State.CONNECTED;
        }
        return rc;
    }

    private int processError(Msg msg) {
        if (this.state != State.EXPECT_WELCOME && this.state != State.EXPECT_READY) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        this.state = State.ERROR_RECEIVED;
        return this.parseErrorMessage(msg);
    }

    private static enum State {
        SEND_HELLO,
        EXPECT_WELCOME,
        SEND_INITIATE,
        EXPECT_READY,
        ERROR_RECEIVED,
        CONNECTED;

    }
}

