/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.events.BeforeBrowseEvent;
import com.equo.chromium.events.BeforePopupEvent;
import com.equo.chromium.events.BrowserEvent;
import com.equo.chromium.events.BrowserEventListener;
import com.equo.chromium.events.EventType;
import com.equo.chromium.events.LoadEndEvent;
import com.equo.chromium.events.SimpleEvent;
import com.equo.chromium.utils.ISubscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Subscriber
implements ISubscriber {
    private final Map<EventType, List<BrowserEventListener<? extends BrowserEvent>>> listeners = new HashMap<EventType, List<BrowserEventListener<? extends BrowserEvent>>>();
    private final Map<BrowserEventListener<?>, EventType> listenerToType = new HashMap();

    private synchronized <T extends BrowserEvent> void subscribe(EventType eventType, BrowserEventListener<T> listener) {
        this.listeners.computeIfAbsent(eventType, m -> new ArrayList()).add(listener);
        this.listenerToType.put(listener, eventType);
    }

    @Override
    public synchronized <E extends BrowserEvent> boolean unsubscribe(BrowserEventListener<E> browserEventListener) {
        if (browserEventListener == null) {
            return false;
        }
        EventType type = this.listenerToType.remove(browserEventListener);
        if (type == null) {
            return false;
        }
        List<BrowserEventListener<? extends BrowserEvent>> list = this.listeners.get((Object)type);
        if (list != null) {
            list.remove(browserEventListener);
        }
        return true;
    }

    @Override
    public synchronized void unsubscribeAll() {
        this.listeners.clear();
    }

    public synchronized BrowserEvent notifySubscribers(BrowserEvent event) {
        List<BrowserEventListener<? extends BrowserEvent>> listenersT = this.listeners.get((Object)event.getEventType());
        if (listenersT != null) {
            listenersT.forEach(listenerT -> {
                BrowserEventListener typed = listenerT;
                if (EventType.onBeforeBrowse == event.getEventType() || EventType.onBeforePopup == event.getEventType()) {
                    typed.onEvent(event);
                } else {
                    new Thread(() -> typed.onEvent(event)).start();
                }
            });
        }
        return event;
    }

    @Override
    public void onBeforeBrowse(BrowserEventListener<BeforeBrowseEvent> listener) {
        this.subscribe(EventType.onBeforeBrowse, listener);
    }

    @Override
    public void onLoadEnd(BrowserEventListener<LoadEndEvent> listener) {
        this.subscribe(EventType.onLoadEnd, listener);
    }

    @Override
    public void onAfterCreated(BrowserEventListener<SimpleEvent> listener) {
        this.subscribe(EventType.onAfterCreated, listener);
    }

    @Override
    public void onBeforePopup(BrowserEventListener<BeforePopupEvent> listener) {
        this.subscribe(EventType.onBeforePopup, listener);
    }
}

