/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console.entity;

import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ReportableLauncherOptionParser;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestSuiteCollectionLauncherOptionParser
extends ReportableLauncherOptionParser {
    private ConsoleOption<String> testSuiteCollectionOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuiteCollectionPath";
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    };
    private StringConsoleOption browserTypeOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "browserType";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption executionProfileOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "executionProfile";
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public String getDefaultArgumentValue() {
            return "default";
        }
    };
    private StringConsoleOption delayBetweenInstances = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "delayBetweenInstances";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption testsuiteColQueryOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuiteCollectionQuery";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption enableLicenseRetry = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "enableLicenseRetry";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryMaxDuration = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryMaxDuration";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryInterval = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryInterval";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryMaxJitter = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryMaxJitter";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        List<ConsoleOption<?>> allOptions = super.getConsoleOptionList();
        allOptions.add(this.testSuiteCollectionOption);
        allOptions.add(this.browserTypeOption);
        allOptions.add(this.executionProfileOption);
        allOptions.add(this.testsuiteColQueryOption);
        allOptions.add(this.delayBetweenInstances);
        allOptions.add(this.enableLicenseRetry);
        allOptions.add(this.licenseRetryMaxDuration);
        allOptions.add(this.licenseRetryInterval);
        allOptions.add(this.licenseRetryMaxJitter);
        return allOptions;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        super.setArgumentValue(consoleOption, argumentValue);
        if (consoleOption == this.testSuiteCollectionOption || consoleOption == this.browserTypeOption || consoleOption == this.executionProfileOption || consoleOption == this.testsuiteColQueryOption || consoleOption == this.delayBetweenInstances) {
            consoleOption.setValue(argumentValue);
        }
    }

    @Override
    public IConsoleLauncher getConsoleLauncher(ProjectEntity projectEntity, LauncherManager manager) throws ExecutionException, InvalidConsoleArgumentException, ControllerException {
        TestSuiteCollectionEntity testSuiteCollection = this.getTestSuiteCollection(projectEntity, this.testSuiteCollectionOption.getValue());
        if (this.browserTypeOption.getValue() != null) {
            testSuiteCollection.setBrowserType((String)this.browserTypeOption.getValue());
        }
        if (this.executionProfileOption.getValue() != null) {
            testSuiteCollection.setProfileName((String)this.executionProfileOption.getValue());
        }
        if (this.delayBetweenInstances.getValue() != null) {
            try {
                int delay = Integer.parseInt((String)this.delayBetweenInstances.getValue());
                if (delay >= 0 && delay <= 999) {
                    testSuiteCollection.setDelayBetweenInstances(delay);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Map<String, Object> globalVariables = super.getOverridingGlobalVariables();
        Map<String, Object> protectedGlobalVariables = super.getOverridingProtectedGlobalVariables();
        Map<String, String> additionalInfo = this.infoOptionContributor.getOptionValues();
        this.applyTestSuiteCollectionQuery(testSuiteCollection, (String)this.testsuiteColQueryOption.getValue());
        return TestSuiteCollectionConsoleLauncher.newInstance(testSuiteCollection, manager, this.reportableSetting, this.rerunSetting, globalVariables, protectedGlobalVariables, (String)this.executionUUIDOption.getValue(), additionalInfo, (Boolean)this.enableProfilingOption.getValue());
    }

    private void applyTestSuiteCollectionQuery(TestSuiteCollectionEntity testSuiteCollection, String testSuiteColQuery) {
        if (testSuiteColQuery == null) {
            return;
        }
        ArrayList executedTestSuite = new ArrayList();
        if (FilterController.getInstance().isIndexsFilter(testSuiteColQuery)) {
            List filteredByIndex = FilterController.getInstance().filterByIndex(testSuiteCollection.getTestSuiteRunConfigurations(), testSuiteColQuery);
            executedTestSuite.addAll(testSuiteCollection.getTestSuiteRunConfigurations().stream().filter(ts -> ts.isRunEnabled()).filter(ts -> filteredByIndex.contains(ts)).collect(Collectors.toList()));
        } else {
            executedTestSuite.addAll(testSuiteCollection.getTestSuiteRunConfigurations().stream().filter(ts -> ts.isRunEnabled()).filter(ts -> FilterController.getInstance().isMatched((FileEntity)ts.getTestSuiteEntity(), testSuiteColQuery)).collect(Collectors.toList()));
        }
        if (executedTestSuite.size() == 0) {
            LogUtil.logInfo((String)StringConstants.MSG_TSC_QUERY_EMPY_RESULT);
        }
        testSuiteCollection.getTestSuiteRunConfigurations().forEach(ts -> {
            ts.setRunEnabled(false);
            if (executedTestSuite.contains(ts)) {
                ts.setRunEnabled(true);
            }
        });
    }

    @Override
    public ILauncher getIDELauncher(ProjectEntity projectEntity, LauncherManager manager) throws ExecutionException, InvalidConsoleArgumentException, ControllerException {
        TestSuiteCollectionEntity testSuiteCollection = this.getTestSuiteCollection(projectEntity, this.testSuiteCollectionOption.getValue());
        Map<String, Object> globalVariables = super.getOverridingGlobalVariables();
        Map<String, Object> protectedGlobalVariables = super.getOverridingProtectedGlobalVariables();
        Map<String, String> additionalInfo = this.infoOptionContributor.getOptionValues();
        return TestSuiteCollectionConsoleLauncher.newIDEInstance(testSuiteCollection, manager, this.reportableSetting, this.rerunSetting, globalVariables, protectedGlobalVariables, (String)this.executionUUIDOption.getValue(), additionalInfo, (Boolean)this.enableProfilingOption.getValue());
    }

    private TestSuiteCollectionEntity getTestSuiteCollection(ProjectEntity projectEntity, String testSuiteCollectionID) throws InvalidConsoleArgumentException {
        try {
            TestSuiteCollectionEntity testSuite = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(testSuiteCollectionID);
            if (testSuite == null) {
                throw this.createInvalidTestSuiteCollectionIdException(testSuiteCollectionID);
            }
            return testSuite;
        }
        catch (DALException dALException) {
            throw this.createInvalidTestSuiteCollectionIdException(testSuiteCollectionID);
        }
    }

    private InvalidConsoleArgumentException createInvalidTestSuiteCollectionIdException(String testSuiteCollectionID) throws InvalidConsoleArgumentException {
        return new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_TEST_SUITE_X_NOT_FOUND, testSuiteCollectionID));
    }
}

