/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.logging;

import com.kms.katalon.execution.addon.ExecutionBundleActivator;
import com.kms.katalon.execution.logging.IOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class RecordingOutputStreamHandler
extends Thread
implements IOutputStream {
    private IEventBroker eventBroker = ExecutionBundleActivator.getInstance().getEventBroker();
    private final InputStream is;
    private final OutputType type;

    private RecordingOutputStreamHandler(InputStream is, OutputType type) {
        this.is = is;
        this.type = type;
    }

    @Override
    public void run() {
        block6: {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(this.is, "UTF-8");
                    br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        this.println(line);
                    }
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
        }
    }

    public static RecordingOutputStreamHandler outputHandlerFrom(InputStream is) {
        return new RecordingOutputStreamHandler(is, OutputType.OUTPUT);
    }

    public static RecordingOutputStreamHandler errorHandlerFrom(InputStream is) {
        return new RecordingOutputStreamHandler(is, OutputType.ERROR);
    }

    @Override
    public void println(String line) throws IOException {
        this.eventBroker.post("WEBUI_VERIFICATION/LOG_UPDATED", (Object)RecordedOutputLine.newInstance(this.type, line));
    }

    @Override
    public void close() throws IOException {
    }

    public static enum OutputType {
        OUTPUT,
        ERROR;

    }

    public static class RecordedOutputLine {
        private final OutputType type;
        private final String text;

        private RecordedOutputLine(OutputType type, String text) {
            this.type = type;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public OutputType getType() {
            return this.type;
        }

        public static RecordedOutputLine newInstance(OutputType type, String text) {
            return new RecordedOutputLine(type, text);
        }
    }
}

