/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.part;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.controller.AutoHealingController;
import com.katalon.plugin.smart_xpath.part.composites.BrokenTestObjectsTableComposite;
import com.katalon.plugin.smart_xpath.part.composites.SelfHealingToolbarComposite;
import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.BrokenTestObjects;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SelfHealingInsightsPart
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    protected BrokenTestObjectsTableComposite brokenTestObjectsTableComposite;
    protected SelfHealingToolbarComposite toolbarComposite;
    private static SelfHealingInsightsPart prevInstance;
    private static long prevFocusTime;

    static {
        prevFocusTime = 0L;
    }

    @PostConstruct
    public void init(Composite parent) {
        this.createContents(parent);
        this.registerEventListeners();
        this.initialize();
        if (prevInstance != null) {
            prevInstance.preDestroy();
        }
        prevInstance = this;
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
        if (!this.brokenTestObjectsTableComposite.isDisposed()) {
            this.brokenTestObjectsTableComposite.dispose();
            this.brokenTestObjectsTableComposite = null;
        }
        if (!this.toolbarComposite.isDisposed()) {
            this.toolbarComposite.dispose();
            this.toolbarComposite = null;
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createContainer(parent);
        this.createBrokenTestObjectsTable(container);
        this.createToolbar(container);
        return parent;
    }

    protected Composite createContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        return container;
    }

    private Composite createBrokenTestObjectsTable(Composite parent) {
        this.brokenTestObjectsTableComposite = new BrokenTestObjectsTableComposite(parent, 0);
        this.brokenTestObjectsTableComposite.setMouseEventListener(this.trackBrokenTestObjectsFileListener());
        return this.brokenTestObjectsTableComposite;
    }

    protected Composite createToolbar(final Composite parent) {
        this.toolbarComposite = new SelfHealingToolbarComposite(parent, 0);
        this.toolbarComposite.setMouseTrackListenerToAllButtons(this.trackBrokenTestObjectsFileListener());
        this.toolbarComposite.addApproveListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!SelfHealingInsightsPart.this.canUseSelfHealing()) {
                    SelfHealingInsightsPart.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SELF_HEALING);
                    return;
                }
                Set<BrokenTestObject> selectedBrokenTestObjects = SelfHealingInsightsPart.this.brokenTestObjectsTableComposite.getSelectedTestObjects();
                int numSelectedTestObjects = selectedBrokenTestObjects.size();
                if (numSelectedTestObjects <= 0) {
                    return;
                }
                AutoHealingController.autoHealBrokenTestObjects(Display.getCurrent().getActiveShell(), selectedBrokenTestObjects);
                ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                Set<BrokenTestObject> deselectedBrokenTestObjects = SelfHealingInsightsPart.this.brokenTestObjectsTableComposite.getDeselectedTestObjects();
                BrokenTestObjects brokenTestObjects = new BrokenTestObjects();
                brokenTestObjects.setBrokenTestObjects(deselectedBrokenTestObjects);
                AutoHealingController.writeBrokenTestObjects(brokenTestObjects, currentProject);
                SelfHealingInsightsPart.this.refresh();
                SelfHealingInsightsPart.this.toolbarComposite.notifyRecoverSucceeded(numSelectedTestObjects);
                String approvedProposals = selectedBrokenTestObjects.stream().map(brokenTestObject -> MessageFormat.format("{0}:{1}", brokenTestObject.getBrokenLocatorMethod(), brokenTestObject.getRecoveryMethod())).collect(Collectors.joining(","));
                Trackings.trackApproveSelfHealingTestObjects((String)approvedProposals);
            }
        });
        this.toolbarComposite.addDiscardListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!SelfHealingInsightsPart.this.canUseSelfHealing()) {
                    SelfHealingInsightsPart.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SELF_HEALING);
                    return;
                }
                Set<BrokenTestObject> selectedBrokenTestObjects = SelfHealingInsightsPart.this.brokenTestObjectsTableComposite.getSelectedTestObjects();
                int numSelectedTestObjects = selectedBrokenTestObjects.size();
                if (numSelectedTestObjects > 0) {
                    SelfHealingInsightsPart.this.toolbarComposite.clearStatusMessage();
                    boolean isOK = MessageDialog.openQuestion((Shell)parent.getShell(), (String)"Self-healing Insights", (String)MessageFormat.format(SmartXPathMessageConstants.MSG_DISCARD_BROKEN_TEST_OBJECT_DIALOG, numSelectedTestObjects));
                    if (isOK) {
                        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                        Set<BrokenTestObject> deselectedBrokenTestObjects = SelfHealingInsightsPart.this.brokenTestObjectsTableComposite.getDeselectedTestObjects();
                        BrokenTestObjects brokenTestObjects = new BrokenTestObjects();
                        brokenTestObjects.setBrokenTestObjects(deselectedBrokenTestObjects);
                        AutoHealingController.writeBrokenTestObjects(brokenTestObjects, currentProject);
                        SelfHealingInsightsPart.this.refresh();
                        SelfHealingInsightsPart.this.toolbarComposite.notifyDiscardSucceeded(numSelectedTestObjects);
                        String discardedProposals = selectedBrokenTestObjects.stream().map(brokenTestObject -> MessageFormat.format("{0}:{1}", brokenTestObject.getBrokenLocatorMethod(), brokenTestObject.getRecoveryMethod())).collect(Collectors.joining(","));
                        Trackings.trackDiscardSelfHealingTestObjects((String)discardedProposals);
                    }
                }
            }
        });
        this.toolbarComposite.addConfigureListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfHealingInsightsPart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.katalon.katalon-studio-smart-xpath.self_healing.webui");
                Trackings.trackClickOnSelfHealingInsightsConfigure();
            }
        });
        return this.toolbarComposite;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("SELF_HEALING_INSIGHTS/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("JOB/COMPLETED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
    }

    protected void initialize() {
        this.refresh();
    }

    @Focus
    public void onFocus() {
        if (System.currentTimeMillis() - prevFocusTime < 1000L) {
            return;
        }
        prevFocusTime = System.currentTimeMillis();
        this.refresh();
        Trackings.trackOpenSelfHealingInsights();
    }

    public void handleEvent(Event event) {
        this.refresh();
        this.toolbarComposite.clearStatusMessage();
    }

    private void refresh() {
        this.loadBrokenTestObjects();
        this.addNotificationNumber();
    }

    public void loadBrokenTestObjects() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        this.brokenTestObjectsTableComposite.setProject(currentProject);
        Set<BrokenTestObject> brokenTestObjects = AutoHealingController.readUnapprovedBrokenTestObjects(currentProject);
        this.brokenTestObjectsTableComposite.setInput(brokenTestObjects);
    }

    private void addNotificationNumber() {
        MApplication application;
        List psList;
        MPartStack consolePartStack;
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MPart selfHealingInsightsPart = (MPart)modelService.find("com.kms.katalon.composer.execution.part.selfHealing", (MUIElement)(consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)(psList = modelService.findElements((MUIElement)(application = ApplicationSingleton.getInstance().getApplication()), null, MPerspectiveStack.class, null)).get(0)).getSelectedElement())));
        if (selfHealingInsightsPart == null) {
            return;
        }
        int numBrokenTestObjects = 0;
        Set<BrokenTestObject> brokenTestObjects = this.brokenTestObjectsTableComposite.getInput();
        if (brokenTestObjects != null && !brokenTestObjects.isEmpty()) {
            numBrokenTestObjects = brokenTestObjects.size();
        }
        String selfHealingInsightsLabel = "Self-healing Insights";
        if (numBrokenTestObjects > 0) {
            selfHealingInsightsPart.getTransientData().put("IconUriForPart", "platform:/plugin/com.katalon.katalon-studio-smart-xpath/resources/icons/self_healing_notification_16px.png");
            selfHealingInsightsPart.setIconURI("platform:/plugin/com.katalon.katalon-studio-smart-xpath/resources/icons/self_healing_notification_16px.png");
            selfHealingInsightsPart.setLabel(MessageFormat.format("{0} ({1})", selfHealingInsightsLabel, numBrokenTestObjects));
        } else {
            selfHealingInsightsPart.getTransientData().put("IconUriForPart", "platform:/plugin/com.katalon.katalon-studio-smart-xpath/resources/icons/self_healing_16px.png");
            selfHealingInsightsPart.setIconURI("platform:/plugin/com.katalon.katalon-studio-smart-xpath/resources/icons/self_healing_16px.png");
            selfHealingInsightsPart.setLabel(selfHealingInsightsLabel);
        }
    }

    private MouseTrackListener trackBrokenTestObjectsFileListener() {
        return new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        };
    }
}

