/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings;

import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.katalon.plugin.smart_xpath.settings.AbstractSettingPage;
import com.katalon.plugin.smart_xpath.settings.composites.AttributesSelectionComposite;
import com.katalon.plugin.smart_xpath.settings.composites.DefaultWebLocatorSelectionComposite;
import com.katalon.plugin.smart_xpath.settings.composites.RecorderPlusSettingComposite;
import com.katalon.plugin.smart_xpath.settings.composites.XPathsSelectionComposite;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelfHealingTestDesignSettingPage
extends AbstractSettingPage {
    @Inject
    IEclipseContext context;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private final Map<String, SelectorMethod> defaultLocatorOptions = new LinkedHashMap<String, SelectorMethod>(){
        {
            this.put("XPath", SelectorMethod.XPATH);
            this.put("Attributes", SelectorMethod.BASIC);
        }
    };
    private DefaultWebLocatorSelectionComposite defaultWebLocatorComposite;
    private RecorderPlusSettingComposite recorderPlusComposite;
    private XPathsSelectionComposite XPathComposite;
    private AttributesSelectionComposite attributesComposite;

    @Override
    protected void createSettingsArea(Composite containter) {
        this.createDefaultLocatorSelectionArea(this.container);
        this.createRecorderPlusArea(containter);
        this.createLocatorPriorityTabs(this.container);
    }

    private Composite createDefaultLocatorSelectionArea(Composite parent) {
        if (this.defaultWebLocatorComposite == null) {
            this.defaultWebLocatorComposite = new DefaultWebLocatorSelectionComposite(parent, 0);
            ContextInjectionFactory.inject((Object)((Object)this.defaultWebLocatorComposite), (IEclipseContext)this.context);
            this.defaultWebLocatorComposite.createContents();
            this.defaultWebLocatorComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.defaultWebLocatorComposite, null);
                }
            });
        }
        return this.defaultWebLocatorComposite;
    }

    private Composite createRecorderPlusArea(Composite parent) {
        if (this.recorderPlusComposite == null) {
            this.recorderPlusComposite = new RecorderPlusSettingComposite(parent, 0);
            this.recorderPlusComposite.addExclusionPatternKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.defaultWebLocatorComposite, null);
                }
            });
        }
        return this.recorderPlusComposite;
    }

    private Composite createLocatorPriorityTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, -1, true, false));
        this.defaultLocatorOptions.forEach((label, selectorMethod) -> {
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setText(label);
            Control tabContent = this.getTabContentBySelectorMethod((SelectorMethod)selectorMethod, (Composite)tabFolder);
            tabItem.setControl(tabContent);
        });
        tabFolder.setSelection(0);
        return tabFolder;
    }

    private Control getTabContentBySelectorMethod(SelectorMethod selectorMethod, Composite parent) {
        switch (selectorMethod) {
            case XPATH: {
                return this.createXPathComposite(parent);
            }
            case BASIC: {
                return this.createAttributesComposite(parent);
            }
        }
        return null;
    }

    private Composite createXPathComposite(Composite parent) {
        if (this.XPathComposite == null) {
            this.XPathComposite = new XPathsSelectionComposite(parent, 0);
            this.XPathComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.XPathComposite, null);
                }
            });
        }
        return this.XPathComposite;
    }

    private Control createAttributesComposite(Composite parent) {
        if (this.attributesComposite == null) {
            this.attributesComposite = new AttributesSelectionComposite(parent, 0);
            this.attributesComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingTestDesignSettingPage.this.handleInputChanged((Control)SelfHealingTestDesignSettingPage.this.attributesComposite, null);
                }
            });
        }
        return this.attributesComposite;
    }

    @Override
    protected void initialize() throws IOException {
        WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
        this.defaultWebLocatorComposite.setInput(store.getCapturedTestObjectSelectorMethod(), store.getSelectorMethodIsSmartLocator());
        this.XPathComposite.setInput(store.getCapturedTestObjectXpathLocators());
        this.attributesComposite.setInput(store.getCapturedTestObjectAttributeLocators());
        this.recorderPlusComposite.setExclusionPattern(store.getRecorderExclusionPattern());
    }

    @Override
    protected void performDefaults() {
        if (!this.featureController.canUse(ProductFeature.SELF_HEALING)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.SELF_HEALING);
            return;
        }
        try {
            WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
            store.setDefaultCapturedTestObjectSelectorMethods();
            store.setDefaultCapturedTestObjectXpathLocators();
            store.setDefaultCapturedTestObjectAttributeLocators();
            store.setDefaultRecorderExclusionPattern();
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
        }
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        try {
            WebUiExecutionSettingStore store = WebUiExecutionSettingStore.getStore();
            if (!this.defaultWebLocatorComposite.isUsingSmartLocator()) {
                store.setCapturedTestObjectSelectorMethod(this.defaultWebLocatorComposite.getInput());
                store.setBufferedSelectorMethod(this.defaultWebLocatorComposite.getInput());
            }
            store.setSelectorMethodIsSmartLocator(this.defaultWebLocatorComposite.isUsingSmartLocator());
            store.setCapturedTestObjectXpathLocators(this.XPathComposite.getInput());
            store.setCapturedTestObjectAttributeLocators(this.attributesComposite.getInput());
            store.setRecorderExclusionPattern(this.recorderPlusComposite.getExclusionPattern());
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() {
        WebUiExecutionSettingStore store;
        block9: {
            boolean isSelectedAttributesChanged;
            block8: {
                boolean isXPathLocatorsChanged;
                block7: {
                    boolean isSelectorMethodChanged;
                    if (!this.isValid()) {
                        return false;
                    }
                    store = WebUiExecutionSettingStore.getStore();
                    SelectorMethod originalSelectorMethod = store.getCapturedTestObjectSelectorMethod();
                    boolean bl = isSelectorMethodChanged = !this.defaultWebLocatorComposite.compareInput(originalSelectorMethod);
                    if (!isSelectorMethodChanged) break block7;
                    return true;
                }
                List originalXPathLocatorsPriority = store.getCapturedTestObjectXpathLocators();
                boolean bl = isXPathLocatorsChanged = !this.XPathComposite.compareInput(originalXPathLocatorsPriority);
                if (!isXPathLocatorsChanged) break block8;
                return true;
            }
            List originalSelectedAttributes = store.getCapturedTestObjectAttributeLocators();
            boolean bl = isSelectedAttributesChanged = !this.attributesComposite.compareInput(originalSelectedAttributes);
            if (!isSelectedAttributesChanged) break block9;
            return true;
        }
        try {
            String originalRecorderExclusionPattern = store.getRecorderExclusionPattern();
            if (!this.recorderPlusComposite.compareExclusionPattern(originalRecorderExclusionPattern)) {
                return true;
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        return false;
    }

    @Override
    public boolean hasDocumentation() {
        return true;
    }

    @Override
    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_WEBLOCATORS;
    }
}

