/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings.composites;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.settings.composites.ExcludeKeywordsEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ExcludeObjectsUsedWithKeywordsComposite
extends Composite {
    private TableViewer tableViewer;
    private List<String> excludeKeywordNames = WebUiExecutionSettingStore.DEFAULT_EXCLUDE_KEYWORDS;
    private List<String> excludeKeywordNamesDoNotShowOnUI = Collections.emptyList();

    public ExcludeObjectsUsedWithKeywordsComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent(parent);
    }

    public void createContent(Composite parent) {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Group excludeKeywordsGroup = new Group((Composite)this, 0);
        excludeKeywordsGroup.setLayout((Layout)new GridLayout());
        excludeKeywordsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        excludeKeywordsGroup.setText(SmartXPathMessageConstants.LABEL_EXCLUDE_OBJECTS_USED_WITH_KEYWORDS);
        Composite compositeToolbar = new Composite((Composite)excludeKeywordsGroup, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.setText("Add");
        tltmAddVariable.setImage(ImageManager.getImage((String)"add_16.png"));
        Menu addMenu = new Menu((Control)tltmAddVariable.getParent().getShell());
        tltmAddVariable.setData((Object)addMenu);
        tltmAddVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int newDefaultKeywordIndex = 0;
                List webUIKeywordList = KeywordController.getInstance().getBuiltInKeywords(SmartXPathMessageConstants.WEB_UI_BUILT_IN_KEYWORDS_SIMPLE_CLASS_NAME, true);
                webUIKeywordList = webUIKeywordList.stream().filter(keyword -> !ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNamesDoNotShowOnUI.contains(keyword.getName())).collect(Collectors.toList());
                KeywordMethod newDefaultKeyword = (KeywordMethod)webUIKeywordList.get(newDefaultKeywordIndex);
                int i = 0;
                while (i < ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.size()) {
                    if (newDefaultKeyword.getName().equals(ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.get(i))) {
                        newDefaultKeyword = (KeywordMethod)webUIKeywordList.get(++newDefaultKeywordIndex);
                        i = -1;
                    }
                    ++i;
                }
                ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.add(newDefaultKeyword.getName());
                ExcludeObjectsUsedWithKeywordsComposite.this.tableViewer.refresh();
                ExcludeObjectsUsedWithKeywordsComposite.this.handleSelectionChange(null);
            }
        });
        ToolItem tltmRemoveVariable = new ToolItem(toolBar, 0);
        tltmRemoveVariable.setText("Remove");
        tltmRemoveVariable.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmRemoveVariable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Table table = ExcludeObjectsUsedWithKeywordsComposite.this.tableViewer.getTable();
                table.setRedraw(false);
                IStructuredSelection selection = (IStructuredSelection)ExcludeObjectsUsedWithKeywordsComposite.this.tableViewer.getSelection();
                for (String selectedObject : selection) {
                    ExcludeObjectsUsedWithKeywordsComposite.this.tableViewer.remove((Object)selectedObject);
                    ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.remove(selectedObject);
                }
                table.setRedraw(true);
                if (OSUtil.isMacBigSurOrLater()) {
                    table.redraw();
                }
                ExcludeObjectsUsedWithKeywordsComposite.this.handleSelectionChange(null);
            }
        });
        Composite tableExcludeObjectsWithKeywordsComposite = new Composite((Composite)excludeKeywordsGroup, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true, 1, 1);
        ldTableComposite.minimumHeight = 100;
        tableExcludeObjectsWithKeywordsComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableExcludeObjectsWithKeywordsComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableExcludeObjectsWithKeywordsComposite, 68114);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tvcName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tName = tvcName.getColumn();
        tName.setText(SmartXPathMessageConstants.COLUMN_KEYWORD);
        tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SelectorMethod label = (SelectorMethod)element;
                return label.getName();
            }
        });
        tvcName.setEditingSupport((EditingSupport)new ExcludeKeywordsEditingSupport(this.tableViewer, this.getWebUIKeywordsStringList()){

            @Override
            protected void setValue(Object element, Object value) {
                if (element != null && element instanceof String && value != null && value instanceof String) {
                    if (ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNamesDoNotShowOnUI.contains(value)) {
                        return;
                    }
                    String property = (String)element;
                    if (!value.equals(property)) {
                        try {
                            KeywordMethod newProperty = KeywordController.getInstance().getBuiltInKeywordByName(SmartXPathMessageConstants.WEB_UI_BUILT_IN_KEYWORDS_CLASS_NAME, (String)value);
                            int changedKeywordIndex = ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.indexOf(property);
                            if (changedKeywordIndex >= 0) {
                                ExcludeObjectsUsedWithKeywordsComposite.this.excludeKeywordNames.set(changedKeywordIndex, newProperty.getName());
                            }
                            ExcludeObjectsUsedWithKeywordsComposite.this.tableViewer.refresh();
                            ExcludeObjectsUsedWithKeywordsComposite.this.handleSelectionChange(null);
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return this.getCellEditor(element, ExcludeObjectsUsedWithKeywordsComposite.this.getWebUIKeywordsStringList());
            }
        });
        tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String keyword = (String)element;
                return keyword;
            }
        });
        tableColumnLayout.setColumnData((Widget)tName, (ColumnLayoutData)new ColumnWeightData(80, 100));
        Composite warningComposite = new Composite((Composite)excludeKeywordsGroup, 0);
        warningComposite.setLayout((Layout)new GridLayout());
        warningComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label warningLabel = new Label(warningComposite, 64);
        warningLabel.setText("* Enabling Self-Healing for wait and verify keywords may cause false positives, flaky tests, or hide real issues. Use only for interaction steps.");
        warningLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        ControlUtils.setFontStyle((Control)warningLabel, (int)2, (int)12);
    }

    public void setInput(List<String> excludeKeywordNames, List<String> excludeKeywordNamesDoNotShowOnUI) {
        this.excludeKeywordNames = excludeKeywordNames;
        this.excludeKeywordNamesDoNotShowOnUI = excludeKeywordNamesDoNotShowOnUI;
        this.tableViewer.setInput(this.excludeKeywordNames);
    }

    private String[] getWebUIKeywordsStringList() {
        List webUIKeywordList = KeywordController.getInstance().getBuiltInKeywords(SmartXPathMessageConstants.WEB_UI_BUILT_IN_KEYWORDS_SIMPLE_CLASS_NAME, true);
        ArrayList<String> webUIKeywordStringList = new ArrayList<String>();
        for (KeywordMethod keyword : webUIKeywordList) {
            if (this.excludeKeywordNames.contains(keyword.getName()) || this.excludeKeywordNamesDoNotShowOnUI.contains(keyword.getName())) continue;
            webUIKeywordStringList.add(keyword.getName());
        }
        return webUIKeywordStringList.toArray(new String[0]);
    }

    public List<String> getInput() {
        return this.excludeKeywordNames;
    }

    public boolean compareInput(List<String> excludeKeywordNamesBeforeSetting) {
        return this.excludeKeywordNames != null && this.excludeKeywordNames.equals(excludeKeywordNamesBeforeSetting);
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((EventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }
}

