/*
 * Decompiled with CFR 0.152.
 */
package graphql.agent.result;

import graphql.PublicApi;
import graphql.execution.ResultPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.dataloader.DataLoader;

@PublicApi
public class ExecutionTrackingResult {
    public static final String EXECUTION_TRACKING_KEY = "__GJ_AGENT_EXECUTION_TRACKING";
    public final AtomicReference<String> startThread = new AtomicReference();
    public final AtomicReference<String> endThread = new AtomicReference();
    public final AtomicLong startExecutionTime = new AtomicLong();
    public final AtomicLong endExecutionTime = new AtomicLong();
    public final Map<ResultPath, String> resultPathToDataLoaderUsed = new ConcurrentHashMap<ResultPath, String>();
    public final Map<DataLoader, String> dataLoaderToName = new ConcurrentHashMap<DataLoader, String>();
    public final Map<ResultPath, Long> timePerPath = new ConcurrentHashMap<ResultPath, Long>();
    public final Map<ResultPath, Long> finishedTimePerPath = new ConcurrentHashMap<ResultPath, Long>();
    public final Map<ResultPath, String> finishedThreadPerPath = new ConcurrentHashMap<ResultPath, String>();
    public final Map<ResultPath, String> startInvocationThreadPerPath = new ConcurrentHashMap<ResultPath, String>();
    private final Map<ResultPath, DFResultType> dfResultTypes = new ConcurrentHashMap<ResultPath, DFResultType>();
    public final Map<String, List<BatchLoadingCall>> dataLoaderNameToBatchCall = new ConcurrentHashMap<String, List<BatchLoadingCall>>();

    public String print(String executionId) {
        StringBuilder s = new StringBuilder();
        s.append("==========================").append("\n");
        s.append("Summary for execution with id ").append(executionId).append("\n");
        s.append("==========================").append("\n");
        s.append("Execution time in ms:").append((this.endExecutionTime.get() - this.startExecutionTime.get()) / 1000000L).append("\n");
        s.append("Fields count: ").append(this.timePerPath.keySet().size()).append("\n");
        s.append("Blocking fields count: ").append(this.dfResultTypes.values().stream().filter(dfResultType -> dfResultType != DFResultType.PENDING).count()).append("\n");
        s.append("Nonblocking fields count: ").append(this.dfResultTypes.values().stream().filter(dfResultType -> dfResultType == DFResultType.PENDING).count()).append("\n");
        s.append("DataLoaders used: ").append(this.dataLoaderToName.size()).append("\n");
        s.append("DataLoader names: ").append(this.dataLoaderToName.values()).append("\n");
        s.append("start execution thread: '").append(this.startThread.get()).append("'\n");
        s.append("end execution  thread: '").append(this.endThread.get()).append("'\n");
        s.append("BatchLoader calls details: ").append("\n");
        s.append("==========================").append("\n");
        for (String dataLoaderName : this.dataLoaderNameToBatchCall.keySet()) {
            s.append("Batch call: '").append(dataLoaderName).append("' made ").append(this.dataLoaderNameToBatchCall.get(dataLoaderName).size()).append(" times, ").append("\n");
            for (BatchLoadingCall batchLoadingCall : this.dataLoaderNameToBatchCall.get(dataLoaderName)) {
                s.append("Batch call with ").append(batchLoadingCall.keyCount).append(" keys ").append(" in thread ").append(batchLoadingCall.threadName).append("\n");
            }
            ArrayList<ResultPath> resultPathUsed = new ArrayList<ResultPath>();
            for (ResultPath resultPath : this.resultPathToDataLoaderUsed.keySet()) {
                if (!this.resultPathToDataLoaderUsed.get(resultPath).equals(dataLoaderName)) continue;
                resultPathUsed.add(resultPath);
            }
            s.append("DataLoader: '").append(dataLoaderName).append("' used in fields: ").append(resultPathUsed).append("\n");
        }
        s.append("Field details:").append("\n");
        s.append("===============").append("\n");
        for (ResultPath path : this.timePerPath.keySet()) {
            s.append("Field: '").append(path).append("'\n");
            s.append("invocation time: ").append(this.timePerPath.get(path)).append(" nano seconds, ").append("\n");
            s.append("completion time: ").append(this.finishedTimePerPath.get(path)).append(" nano seconds, ").append("\n");
            s.append("Result type: ").append((Object)this.dfResultTypes.get(path)).append("\n");
            s.append("invoked in thread: ").append(this.startInvocationThreadPerPath.get(path)).append("\n");
            s.append("finished in thread: ").append(this.finishedThreadPerPath.get(path)).append("\n");
            s.append("-------------\n");
        }
        s.append("==========================").append("\n");
        s.append("==========================").append("\n");
        return s.toString();
    }

    public String toString() {
        return "ExecutionData{resultPathToDataLoaderUsed=" + this.resultPathToDataLoaderUsed + ", dataLoaderNames=" + this.dataLoaderToName.values() + ", timePerPath=" + this.timePerPath + ", dfResultTypes=" + this.dfResultTypes + "}";
    }

    public List<String> getDataLoaderNames() {
        return new ArrayList<String>(this.dataLoaderToName.values());
    }

    public void start(ResultPath path, long startTime) {
        this.timePerPath.put(path, startTime);
    }

    public void end(ResultPath path, long endTime) {
        this.timePerPath.put(path, endTime - this.timePerPath.get(path));
    }

    public int dataFetcherCount() {
        return this.timePerPath.size();
    }

    public long getTime(ResultPath path) {
        return this.timePerPath.get(path);
    }

    public long getTime(String path) {
        return this.timePerPath.get(ResultPath.parse(path));
    }

    public void setDfResultTypes(ResultPath resultPath, DFResultType resultTypes) {
        this.dfResultTypes.put(resultPath, resultTypes);
    }

    public DFResultType getDfResultTypes(ResultPath resultPath) {
        return this.dfResultTypes.get(resultPath);
    }

    public DFResultType getDfResultTypes(String resultPath) {
        return this.dfResultTypes.get(ResultPath.parse(resultPath));
    }

    public static enum DFResultType {
        DONE_OK,
        DONE_EXCEPTIONALLY,
        DONE_CANCELLED,
        PENDING;

    }

    public static class BatchLoadingCall {
        public final int keyCount;
        public final String threadName;

        public BatchLoadingCall(int keyCount, String threadName) {
            this.keyCount = keyCount;
            this.threadName = threadName;
        }
    }
}

