/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.procyon.decompiler;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.DeobfuscationUtilities;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.Language;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.procyon.ProcyonDecompilerPlugin;
import org.sf.feeling.decompiler.procyon.decompiler.LineNumberFormatter;
import org.sf.feeling.decompiler.procyon.decompiler.NoRetryMetadataSystem;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.CommentUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class ProcyonDecompiler
extends BaseDecompiler {
    private String source = "";
    private long time;
    private String log = "";

    public void decompile(String root, String packege, String className) {
        TypeDefinition resolvedType;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.log = "";
        this.source = "";
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        String classPathStr = new File(workingDir, className).getAbsolutePath();
        boolean includeLineNumbers = false;
        boolean stretchLines = false;
        if (ClassUtil.isDebug()) {
            includeLineNumbers = true;
            stretchLines = true;
        }
        DecompilationOptions decompilationOptions = new DecompilationOptions();
        DecompilerSettings settings = DecompilerSettings.javaDefaults();
        settings.setTypeLoader((ITypeLoader)new InputTypeLoader());
        settings.setForceExplicitImports(true);
        decompilationOptions.setSettings(settings);
        decompilationOptions.setFullDecompilation(true);
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(decompilationOptions.getSettings().getTypeLoader());
        metadataSystem.setEagerMethodLoadingEnabled(false);
        TypeReference type = metadataSystem.lookupType(classPathStr);
        if (type == null || (resolvedType = type.resolve()) == null) {
            System.err.printf("!!! ERROR: Failed to load class %s.\n", classPathStr);
            return;
        }
        DeobfuscationUtilities.processType((TypeDefinition)resolvedType);
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File classFile = new File(tempDir, String.valueOf(System.currentTimeMillis()) + className);
        try {
            TypeDecompilationResults results;
            Throwable throwable = null;
            Object var19_19 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(classFile)));){
                PlainTextOutput output = new PlainTextOutput((Writer)writer);
                output.setUnicodeOutputEnabled(decompilationOptions.getSettings().isUnicodeOutputEnabled());
                Language lang = decompilationOptions.getSettings().getLanguage();
                results = lang.decompileType(resolvedType, (ITextOutput)output, decompilationOptions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            List lineNumberPositions = results.getLineNumberPositions();
            if (includeLineNumbers || stretchLines) {
                EnumSet<LineNumberFormatter.LineNumberOption> lineNumberOptions = EnumSet.noneOf(LineNumberFormatter.LineNumberOption.class);
                if (includeLineNumbers) {
                    lineNumberOptions.add(LineNumberFormatter.LineNumberOption.LEADING_COMMENTS);
                }
                if (stretchLines) {
                    lineNumberOptions.add(LineNumberFormatter.LineNumberOption.STRETCHED);
                }
                LineNumberFormatter lineFormatter = new LineNumberFormatter(classFile, lineNumberPositions, lineNumberOptions);
                this.source = lineFormatter.reformatFile();
            } else {
                this.source = FileUtil.getContent((File)classFile);
            }
        }
        catch (IOException e) {
            this.exceptions.add(e);
            Logger.error((Throwable)e);
        }
        this.source = UnicodeUtil.decode((String)this.source);
        classFile.delete();
        this.source = CommentUtil.clearComments((String)this.source);
        this.time = stopWatch.getTime();
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
                this.time = stopWatch.getTime();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "Procyon";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public String getDecompilerName() {
        return "Procyon";
    }

    public String getDecompilerVersion() {
        return ProcyonDecompilerPlugin.decompilerVersion;
    }
}

