/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.TestListenerEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestListenerHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestListenerEntity) {
                    OpenTestListenerHandler.this.openEditor((TestListenerEntity)object);
                }
            }
        });
    }

    ITextEditor openEditor(TestListenerEntity object) {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)currentProject).getFile(Path.fromOSString((String)object.getRelativePath()));
        try {
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
            ITextEditor editor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), desc.getId());
            if (editor instanceof GroovyEditor) {
                GroovyEditorUtil.addImportActions((GroovyEditor)((GroovyEditor)editor));
            }
            return editor;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

