/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CapturedMobileElementBrowserDialog
extends AbstractDialog
implements IAstDialogBuilder {
    private CTableViewer tableViewer;
    private List<CapturedMobileElement> capturedElements;
    private CapturedMobileElement selectedElement;

    public CapturedMobileElementBrowserDialog(Shell parentShell, List<CapturedMobileElement> capturedElements, CapturedMobileElement selectedElement) {
        super(parentShell);
        this.capturedElements = capturedElements;
        this.selectedElement = selectedElement;
    }

    protected void registerControlModifyListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CapturedMobileElement webElement = (CapturedMobileElement)CapturedMobileElementBrowserDialog.this.tableViewer.getStructuredSelection().getFirstElement();
                if (webElement != null) {
                    CapturedMobileElementBrowserDialog.this.selectedElement = webElement;
                }
                CapturedMobileElementBrowserDialog.this.getButton(0).setEnabled(webElement instanceof CapturedMobileElement);
            }
        });
    }

    protected void setInput() {
        this.tableViewer.setInput(this.capturedElements);
        if (this.selectedElement != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement));
        }
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.tableViewer = new CTableViewer(container, 2050);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MobileElementLabelProvider(0));
        return container;
    }

    public Object getReturnValue() {
        return this.selectedElement;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    public String getDialogTitle() {
        return "Captured Mobile Objects";
    }

    private class MobileElementLabelProvider
    extends TypeCheckStyleCellTableLabelProvider<CapturedMobileElement> {
        public MobileElementLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected Class<CapturedMobileElement> getElementType() {
            return CapturedMobileElement.class;
        }

        protected Image getImage(CapturedMobileElement element) {
            return null;
        }

        protected String getText(CapturedMobileElement element) {
            return element.getName();
        }
    }
}

