/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.components.util.ComponentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListDialog
extends Dialog {
    private String[] items;
    private List<String> filteredItems;
    private String selectedItem;
    private String title;
    private String message;
    private ListViewer listViewer;
    private Text searchBox;

    public ListDialog(Shell parentShell, String title, String message, String[] items) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.items = items;
        this.filteredItems = new ArrayList<String>(Arrays.asList(items));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(8);
        layout.marginHeight = this.convertVerticalDLUsToPixels(8);
        container.setLayout((Layout)layout);
        if (this.message != null) {
            Label messageLabel = new Label(container, 64);
            messageLabel.setText(this.message);
            messageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.searchBox = new Text(container, 2432);
        GridData searchBoxGridData = new GridData(4, 0x1000000, true, false);
        searchBoxGridData.verticalIndent = this.convertVerticalDLUsToPixels(5);
        this.searchBox.setLayoutData((Object)searchBoxGridData);
        this.searchBox.setMessage("Type to search...");
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ListDialog.this.filterItems(ListDialog.this.searchBox.getText());
            }
        });
        this.listViewer = new ListViewer(container, 2564);
        GridData listViewerGridData = new GridData(4, 4, true, true);
        listViewerGridData.verticalIndent = this.convertVerticalDLUsToPixels(4);
        listViewerGridData.heightHint = ComponentUtil.applyScaleFactor((int)200);
        listViewerGridData.widthHint = ComponentUtil.applyScaleFactor((int)300);
        this.listViewer.getList().setLayoutData((Object)listViewerGridData);
        this.listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewer.setInput((Object)this.filteredItems.toArray(new String[0]));
        this.selectFirstItem();
        this.listViewer.addSelectionChangedListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            this.selectedItem = (String)selection.getFirstElement();
        });
        return container;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected Point getInitialSize() {
        int width = ComponentUtil.applyScaleFactor((int)400);
        int height = ComponentUtil.applyScaleFactor((int)300);
        return new Point(width, height);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    private void filterItems(String searchText) {
        this.filteredItems = Arrays.stream(this.items).filter(item -> item.toUpperCase().contains(searchText.toUpperCase())).collect(Collectors.toList());
        this.listViewer.setInput((Object)this.filteredItems.toArray(new String[0]));
        this.selectFirstItem();
    }

    private void selectFirstItem() {
        if (!this.filteredItems.isEmpty()) {
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)this.filteredItems.get(0)), true);
            this.selectedItem = this.filteredItems.get(0);
        } else {
            this.selectedItem = null;
        }
    }
}

