/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.actions.CustomMobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.IMobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParam;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParamValueType;
import com.kms.katalon.composer.mobile.objectspy.components.TestCloudConfigurationsComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveScreenshotDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionHelper;
import com.kms.katalon.composer.mobile.recorder.components.ListDialog;
import com.kms.katalon.composer.mobile.recorder.components.MobileActionButtonWrapper;
import com.kms.katalon.composer.mobile.recorder.composites.GetTextDialog;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.mobile.recorder.interfaces.IMobileObjectRecordDialog;
import com.kms.katalon.composer.mobile.recorder.interfaces.IRecordActionPerformHandler;
import com.kms.katalon.composer.testcase.ast.dialogs.ArgumentInputBuilderDialog;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputParameter;
import com.kms.katalon.composer.testcase.model.InputParameterBuilder;
import com.kms.katalon.composer.testcase.model.InputParameterClass;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.util.CryptoUtil;
import io.appium.java_client.AppiumDriver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Keys;

@Creatable
public class RecordActionPerformHandler
implements IRecordActionPerformHandler {
    private IMobileObjectRecordDialog parentDialog;
    private List<MobileActionButtonWrapper> actionButtons;

    public RecordActionPerformHandler(IMobileObjectRecordDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public RecordActionPerformHandler() {
    }

    @Override
    public void setParentDialog(IMobileObjectRecordDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    @Override
    public Shell getShell() {
        return this.parentDialog != null ? this.parentDialog.getShell() : Display.getCurrent().getActiveShell();
    }

    @Override
    public Composite renderActionButtons(SashForm sashForm, ActionButtonListener buttonListener) {
        Composite actionListComposite = (Composite)ComponentBuilder.gridContainer((Composite)sashForm).build();
        ComponentBuilder.label((Composite)actionListComposite).text(MobileRecoderMessagesConstants.LBL_POSSIBLE_ACTIONS).bold().build();
        Composite buttonsWrapper = (Composite)ComponentBuilder.gridContainer((Composite)actionListComposite, (int)1, (int)0).fill().build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)buttonsWrapper, (int)0).noFillVertical().build();
        RowLayout layout = new RowLayout();
        buttonsComposite.setLayout((Layout)layout);
        this.actionButtons = new ArrayList<MobileActionButtonWrapper>();
        this.actionButtons.addAll(Arrays.asList(MobileAction.values()).stream().filter(action -> action.isUserInputAction()).filter(action -> {
            if (action.getName().equals(MobileAction.InjectImage.toString())) {
                return this.parentDialog.getMobileAppComposite() instanceof TestCloudConfigurationsComposite;
            }
            return true;
        }).map(action -> buttonListener.wrapActionOnClick((MobileAction)action, buttonsComposite)).collect(Collectors.toList()));
        ScrolledComposite scrollContainer = DialogUtil.autoScroll((Composite)buttonsWrapper, (int)512, (boolean)true);
        ComponentEventUtil.addListeners((Widget)actionListComposite, event -> {
            int scrollbarWidth = scrolledComposite.getVerticalBar().getSize().x;
            int width = composite.getSize().x - scrollbarWidth;
            int buttonHeight = this.actionButtons.get((int)0).getButton().computeSize((int)-1, (int)-1).y;
            int childrenHeight = buttonHeight + rowLayout.spacing;
            int lineLength = buttonHeight;
            for (MobileActionButtonWrapper buttonI : this.actionButtons) {
                int buttonWidth = buttonI.getButton().computeSize((int)-1, (int)-1).x;
                buttonHeight = buttonI.getButton().computeSize((int)-1, (int)-1).y;
                if ((lineLength += buttonWidth + rowLayout.spacing) <= width) continue;
                childrenHeight += buttonHeight + rowLayout.spacing;
                lineLength = buttonWidth;
            }
            ComponentUtil.setSize((Control)buttonsComposite, (int)width, (int)childrenHeight);
            buttonsComposite.pack();
            buttonsWrapper.pack();
            scrollContainer.setMinSize(width, childrenHeight);
        }, (int[])new int[]{11});
        scrollContainer.pack();
        actionListComposite.pack();
        return buttonsComposite;
    }

    @Override
    public MobileActionMapping performAction(Shell parentShell, TestObject testObject, MobileAction action, CapturedMobileElement targetElement, MobileActionMapping mobileActionMapping, AppiumDriver driver) throws Exception {
        MobileActionHelper mobileActionHelper = new MobileActionHelper(driver);
        mobileActionMapping.setAction((IMobileAction)action);
        mobileActionMapping.setTargetElement(targetElement);
        switch (action) {
            case ClearText: {
                mobileActionHelper.clearText(testObject);
                break;
            }
            case HideKeyboard: {
                mobileActionHelper.hideKeyboard();
                break;
            }
            case PressBack: {
                mobileActionHelper.pressBack();
                break;
            }
            case GetText: {
                this.handleGetText(testObject, mobileActionMapping, mobileActionHelper);
                break;
            }
            case SetText: {
                this.handleSetText(parentShell, testObject, mobileActionMapping, mobileActionHelper);
                break;
            }
            case SetEncryptedText: {
                this.handleSetEncryptedText(mobileActionHelper, mobileActionMapping, testObject);
                break;
            }
            case ScrollToText: {
                this.handleScrollToText(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SwitchToLandscape: {
                mobileActionHelper.switchToLandscape();
                break;
            }
            case SwitchToPortrait: {
                mobileActionHelper.switchToPortrait();
                break;
            }
            case Tap: {
                mobileActionHelper.tap(testObject);
                break;
            }
            case TapAndHold: {
                this.handleTapAndHoldAction(testObject, mobileActionHelper, mobileActionMapping);
                break;
            }
            case Swipe: {
                this.handleSwipeAction(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SwitchToWebView: {
                mobileActionHelper.switchToWebView();
                break;
            }
            case SwitchToNative: {
                mobileActionHelper.switchToNative();
                break;
            }
            case TakeScreenshot: {
                ArrayList<MobileActionParam> screenshotParams = new ArrayList<MobileActionParam>();
                screenshotParams.add(new MobileActionParam("fileName", String.class));
                action.setParams(screenshotParams.toArray(new MobileActionParam[screenshotParams.size()]));
                mobileActionMapping.setAction((IMobileAction)action);
                this.handleTakeScreenshotAction(mobileActionHelper, mobileActionMapping);
                break;
            }
            case SendKeys: {
                this.handleSendKeys(testObject, mobileActionHelper, mobileActionMapping);
                break;
            }
            case VerifyElementText: {
                this.handleVerifyElementText(testObject, mobileActionHelper, mobileActionMapping);
                break;
            }
            case PressKeyCode: {
                this.handlePressKeyCodeAction(parentShell, mobileActionHelper, mobileActionMapping);
                break;
            }
            case TapAtPosition: {
                this.handleTapAtPositionAction(mobileActionHelper, mobileActionMapping);
                break;
            }
            case PressHome: {
                mobileActionHelper.pressHome();
                break;
            }
            case InjectImage: {
                this.handleInjectImageAction(mobileActionHelper, mobileActionMapping);
            }
        }
        return mobileActionMapping;
    }

    @Override
    public void updateActionButtonsVisibility(MobileElement mobileElement, MobileDriverType currentMobileDriverType, AppiumDriver driver) {
        this.actionButtons.stream().forEach(actionButton -> {
            MobileAction action = actionButton.getMobileAction();
            actionButton.setEnabledButton(driver != null && (!action.hasElement() || mobileElement != null) && currentMobileDriverType != null && action.isDriverTypeSupported(currentMobileDriverType));
        });
    }

    @Override
    public void handleGetText(TestObject testObject, MobileActionMapping mobileActionMapping, MobileActionHelper mobileActionHelper) throws Exception {
        final String elementText = mobileActionHelper.getText(testObject);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                GetTextDialog getTextDialog = new GetTextDialog(RecordActionPerformHandler.this.getShell(), elementText);
                if (getTextDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
    }

    public void handleSetText(final Shell parentShell, TestObject testObject, MobileActionMapping mobileActionMapping, MobileActionHelper mobileActionHelper) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(parentShell, MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null);
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String textInput = stringBuilder.toString();
        if (textInput.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)textInput));
        mobileActionHelper.setText(testObject, textInput);
    }

    @Override
    public void handleSetEncryptedText(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping, TestObject testObject) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(RecordActionPerformHandler.this.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null){

                    protected int getInputTextStyle() {
                        return super.getInputTextStyle() | 0x400000;
                    }
                };
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String password = stringBuilder.toString();
        String encryptedPassword = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)password));
        if (password.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)encryptedPassword));
        mobileActionHelper.setText(testObject, password);
    }

    @Override
    public void handleScrollToText(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(RecordActionPerformHandler.this.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null);
                if (inputDialog.open() == 0) {
                    stringBuilder.append(inputDialog.getValue());
                }
            }
        });
        String textInput = stringBuilder.toString();
        if (textInput.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)textInput));
        mobileActionHelper.scrollToText(textInput);
    }

    @Override
    public void handleSwipeAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass integerParamType = new InputParameterClass(Integer.class);
        ConstantExpressionWrapper defaultValue = new ConstantExpressionWrapper((Object)0);
        parameters.add(new InputParameter("startX", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("startY", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("endX", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("endY", integerParamType, (Object)defaultValue));
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, null);
                if (inputDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
        MobileActionParamValueType[] actionParams = mobileActionMapping.getData();
        List touchCoords = parameterBuilder.getOriginalParameters();
        ArrayList coords = new ArrayList();
        IntStream.range(0, actionParams.length).forEach(index -> {
            coords.add((Integer)((ConstantExpressionWrapper)((InputParameter)touchCoords.get(index)).getValue()).getValue());
            actionParams[index].setValue(((InputParameter)touchCoords.get(index)).getValue());
        });
        if (coords.stream().allMatch(coord -> coord == 0)) {
            throw new CancellationException();
        }
        mobileActionHelper.swipe(((Integer)coords.get(0)).intValue(), ((Integer)coords.get(1)).intValue(), ((Integer)coords.get(2)).intValue(), ((Integer)coords.get(3)).intValue());
    }

    @Override
    public void handleTakeScreenshotAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        final StringBuilder absolutePath = new StringBuilder();
        final StringBuilder messageError = new StringBuilder();
        final File tempFile = mobileActionHelper.takeScreenshot();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SaveScreenshotDialog dialog = new SaveScreenshotDialog(RecordActionPerformHandler.this.getShell());
                    dialog.setFilePath(tempFile.getPath());
                    if (dialog.open() != 0) {
                        FileUtils.forceDelete((File)tempFile);
                        return;
                    }
                    absolutePath.append(dialog.getFilePath());
                    if (!absolutePath.toString().equals(tempFile.getPath())) {
                        FileUtils.copyFile((File)tempFile, (File)new File(absolutePath.toString()));
                        FileUtils.forceDelete((File)tempFile);
                    }
                    Object finalCommand = absolutePath.toString();
                    if (Util.isLinux() || Util.isMac()) {
                        Runtime.getRuntime().exec(new String[]{"open", finalCommand});
                    } else {
                        finalCommand = "CMD /C \"" + absolutePath.toString() + "\"";
                        Runtime.getRuntime().exec((String)finalCommand);
                    }
                }
                catch (Exception e) {
                    messageError.append(e.getMessage());
                    try {
                        FileUtils.forceDelete((File)tempFile);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        String filePath = absolutePath.toString();
        if (filePath.isEmpty()) {
            throw new CancellationException();
        }
        if (filePath.length() > 255) {
            throw new Exception(MessageFormat.format(MobileRecoderMessagesConstants.MSG_ERR_CANNOT_SAVE_SCREENSHOT, filePath.length()));
        }
        if (!messageError.toString().isEmpty()) {
            throw new Exception(messageError.toString());
        }
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)filePath));
    }

    @Override
    public void handleSendKeys(TestObject testObject, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass stringParamType = new InputParameterClass(String.class);
        ConstantExpressionWrapper defaultValue = new ConstantExpressionWrapper((Object)"");
        parameters.add(new InputParameter("strokeKeys", stringParamType, (Object)defaultValue));
        final ASTNodeWrapper astNode = (ASTNodeWrapper)((InputParameter)parameters.get(0)).getValue();
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, astNode);
                if (inputDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
        List keys = parameterBuilder.getOriginalParameters();
        Object key = ((InputParameter)keys.get(0)).getValue();
        String strokeKeys = "";
        if (key instanceof ConstantExpressionWrapper) {
            ConstantExpressionWrapper expression = (ConstantExpressionWrapper)key;
            strokeKeys = (String)expression.getValue();
            mobileActionMapping.getData()[0].setValue((Object)expression);
        } else if (key instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)key;
            ArgumentListExpressionWrapper argumentExpressionWrapper = methodCall.getArguments();
            mobileActionMapping.getData()[0].setValue(key);
            String keysChord = mobileActionHelper.getKeys(argumentExpressionWrapper);
            strokeKeys = Keys.chord((CharSequence[])new CharSequence[]{keysChord});
        }
        mobileActionHelper.sendKeys(testObject, strokeKeys);
    }

    @Override
    public void handleVerifyElementText(TestObject testObject, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)mobileActionHelper.getText(testObject)));
    }

    public void handlePressKeyCodeAction(final Shell parentShell, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        final String[] androidKeyEnums = new String[]{"DIGIT_0", "DIGIT_1", "DIGIT_2", "DIGIT_3", "DIGIT_4", "DIGIT_5", "DIGIT_6", "DIGIT_7", "DIGIT_8", "DIGIT_9", "STAR", "POUND", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        final StringBuilder stringBuilder = new StringBuilder();
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                String selectedItem;
                ListDialog listDialog = new ListDialog(parentShell, MobileRecoderMessagesConstants.DLG_TITLE_SELECT_KEYCODE, MobileRecoderMessagesConstants.DLG_MSG_SELECT_KEYCODE, androidKeyEnums);
                if (listDialog.open() == 0 && StringUtils.isNotBlank((CharSequence)(selectedItem = listDialog.getSelectedItem()))) {
                    stringBuilder.append(selectedItem.trim());
                }
            }
        });
        String keyCode = stringBuilder.toString();
        if (keyCode.isEmpty()) {
            throw new CancellationException();
        }
        mobileActionHelper.pressKeyCode(keyCode);
        mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)keyCode));
    }

    public void handleTapAndHoldAction(TestObject testObject, MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass integerParamType = new InputParameterClass(Integer.class);
        InputParameterClass numberParamType = new InputParameterClass(Number.class);
        parameters.add(new InputParameter("duration", numberParamType, (Object)new ConstantExpressionWrapper((Object)2)));
        int defaultElementTimeout = RunConfiguration.getElementTimeoutForMobile();
        parameters.add(new InputParameter("timeout", integerParamType, (Object)new ConstantExpressionWrapper((Object)defaultElementTimeout)));
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, null);
                if (inputDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
        MobileActionParamValueType[] actionParams = mobileActionMapping.getData();
        List inputParams = parameterBuilder.getOriginalParameters();
        ArrayList values = new ArrayList();
        IntStream.range(0, actionParams.length).forEach(index -> {
            values.add((Integer)((ConstantExpressionWrapper)((InputParameter)inputParams.get(index)).getValue()).getValue());
            actionParams[index].setValue(((InputParameter)inputParams.get(index)).getValue());
        });
        if (values.stream().allMatch(value -> value == 0)) {
            throw new CancellationException();
        }
        mobileActionHelper.tapAndHold(testObject, (Number)values.get(0), ((Integer)values.get(1)).intValue());
    }

    public void handleTapAtPositionAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ArrayList<InputParameter> parameters = new ArrayList<InputParameter>();
        InputParameterClass integerParamType = new InputParameterClass(Integer.class);
        ConstantExpressionWrapper defaultValue = new ConstantExpressionWrapper((Object)0);
        parameters.add(new InputParameter("x", integerParamType, (Object)defaultValue));
        parameters.add(new InputParameter("y", integerParamType, (Object)defaultValue));
        final InputParameterBuilder parameterBuilder = InputParameterBuilder.createForNestedMethodCall(parameters);
        final MutableBoolean isCanceled = new MutableBoolean(false);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArgumentInputBuilderDialog inputDialog = new ArgumentInputBuilderDialog(RecordActionPerformHandler.this.getShell(), parameterBuilder, null);
                if (inputDialog.open() != 0) {
                    isCanceled.setTrue();
                }
            }
        });
        if (isCanceled.isTrue()) {
            throw new CancellationException();
        }
        MobileActionParamValueType[] actionParams = mobileActionMapping.getData();
        List touchCoords = parameterBuilder.getOriginalParameters();
        ArrayList coords = new ArrayList();
        IntStream.range(0, actionParams.length).forEach(index -> {
            coords.add((Integer)((ConstantExpressionWrapper)((InputParameter)touchCoords.get(index)).getValue()).getValue());
            actionParams[index].setValue(((InputParameter)touchCoords.get(index)).getValue());
        });
        if (coords.stream().allMatch(coord -> coord == 0)) {
            throw new CancellationException();
        }
        mobileActionHelper.tapAtPosition((Number)coords.get(0), (Number)coords.get(1));
    }

    public void handleInjectImageAction(MobileActionHelper mobileActionHelper, MobileActionMapping mobileActionMapping) throws Exception {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        String className = "CustomKeywords";
        String methodName = "com.katalon.testcloud.CameraImageInjectionExecutor.injectImage";
        MethodNode methodNode = KeywordController.getInstance().getCustomKeywordByName(className, methodName, projectEntity);
        if (methodNode == null) {
            CancellationException exception = new CancellationException(StringConstants.KW_LOG_FAILED_INJECT_IMAGE);
            String message = "The Katalon TestCloud Keywords plugin has not been installed. To use \u201cInject Image\u201d action, please install the plugin from <a href=\"https://store.katalon.com/product/397/Katalon-TestCloud-Keywords\">here</a>. <a href=\"https://docs.katalon.com/katalon-testcloud/advanced-use-cases/camera-image-injection\">Learn more</a>.";
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)StringConstants.KW_LOG_FAILED_INJECT_IMAGE, (String)message, (Shell)this.getShell());
            throw exception;
        }
        Path projectPath = Paths.get(projectEntity.getFolderLocation(), new String[0]).toAbsolutePath().normalize();
        final Path rootPath = projectPath.resolve("Data Files/TestCloud");
        if (!Files.exists(rootPath, new LinkOption[0])) {
            Files.createDirectories(rootPath, new FileAttribute[0]);
        }
        final String[] selectedFiles = new String[1];
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                FileDialog fileDialog = new FileDialog(RecordActionPerformHandler.this.getShell(), 4096);
                fileDialog.setText("Select an Image File");
                fileDialog.setFilterPath(rootPath.toString());
                fileDialog.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg"});
                fileDialog.setFilterNames(new String[]{"Image Files (*.png, *.jpg, *.jpeg)"});
                selectedFiles[0] = fileDialog.open();
            }
        });
        String selectedFile = selectedFiles[0];
        if (selectedFile != null) {
            try {
                mobileActionHelper.injectImage(selectedFile);
                Path selectedFilePath = Paths.get(selectedFile, new String[0]).toAbsolutePath().normalize();
                String relativeFilePath = "";
                if (!selectedFilePath.startsWith(projectPath)) {
                    Path targetFilePath = rootPath.resolve(selectedFilePath.getFileName());
                    Files.copy(selectedFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
                    relativeFilePath = projectPath.relativize(targetFilePath).toString();
                } else {
                    relativeFilePath = projectPath.relativize(selectedFilePath).toString();
                }
                CustomMobileAction mobileAction = new CustomMobileAction(methodNode, "Inject the image");
                mobileActionMapping.setAction((IMobileAction)mobileAction);
                mobileActionMapping.getData()[0].setValue((Object)new ConstantExpressionWrapper((Object)relativeFilePath));
                return;
            }
            catch (Exception e) {
                throw new CancellationException(e.getMessage());
            }
        }
        throw new CancellationException();
    }

    @FunctionalInterface
    public static interface ActionButtonListener {
        public MobileActionButtonWrapper wrapActionOnClick(MobileAction var1, Composite var2);
    }
}

