/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.handlers.IRequestHistoryListener;
import com.kms.katalon.composer.webservice.settings.WebServicePreferenceStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RequestHistoryHandler {
    private static final String REQUEST_HISTORY_CONTRIBUTION_URI = "bundleclass://com.kms.katalon.composer.webservice/com.kms.katalon.composer.webservice.parts.RequestHistoryPart";
    private static final String REQUEST_HISTORY_ICON_URI = "platform:/plugin/com.kms.katalon.composer.resources/icons/history_request_16.png";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    private RequestHistoryEntity lastestRequest;
    private WebServicePreferenceStore store = new WebServicePreferenceStore();
    private IRequestHistoryListener listener;

    @PostConstruct
    public void initialEventListeners() {
        this.eventBroker.subscribe("WS_VERIFICATION/FINISHED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                RequestHistoryEntity requestHistory = (RequestHistoryEntity)this.getObjects(event)[0];
                try {
                    RequestHistoryHandler.this.addRequestHistory(requestHistory, ProjectController.getInstance().getCurrentProject());
                    if (RequestHistoryHandler.this.listener != null) {
                        RequestHistoryHandler.this.listener.addHistoryRequest(requestHistory);
                    }
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                MPart mpart = RequestHistoryHandler.this.partService.findPart("com.kms.katalon.composer.webservice.part.requestHistory");
                MPartStack stack = (MPartStack)RequestHistoryHandler.this.modelService.find("com.kms.katalon.composer.partstack.explorer", (MUIElement)RequestHistoryHandler.this.application);
                MStackElement selectedPart = (MStackElement)stack.getSelectedElement();
                if (project.getType() == ProjectType.WEBSERVICE) {
                    if (mpart == null) {
                        mpart = (MPart)RequestHistoryHandler.this.modelService.createModelElement(MPart.class);
                        mpart.setElementId("com.kms.katalon.composer.webservice.part.requestHistory");
                        mpart.setLabel(ComposerWebserviceMessageConstants.RequestHistoryHandler_PA_TITLE_REQUEST_HISTORY);
                        mpart.setIconURI(RequestHistoryHandler.REQUEST_HISTORY_ICON_URI);
                        mpart.setContributionURI(RequestHistoryHandler.REQUEST_HISTORY_CONTRIBUTION_URI);
                        mpart.setCloseable(false);
                        stack.getChildren().add(mpart);
                        RequestHistoryHandler.this.partService.showPart(mpart, EPartService.PartState.ACTIVATE);
                    } else {
                        RequestHistoryHandler.this.partService.showPart(mpart, EPartService.PartState.ACTIVATE);
                    }
                } else if (mpart != null) {
                    RequestHistoryHandler.this.partService.hidePart(mpart);
                }
                stack.setSelectedElement((MUIElement)selectedPart);
                if (RequestHistoryHandler.this.listener != null) {
                    RequestHistoryHandler.this.listener.resetInput();
                }
            }
        });
        this.eventBroker.subscribe("PROJECT/CLOSE_AND_CLEAN", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                try {
                    ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                    RequestHistoryHandler.this.store.removeAllRequestHistory(project);
                    if (RequestHistoryHandler.this.listener != null) {
                        RequestHistoryHandler.this.listener.resetInput();
                    }
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    public List<RequestHistoryEntity> getRequestHistoryEntities(ProjectEntity project) {
        return this.store.getHistoryRequestEntities(project);
    }

    public void removeRequestHistories(List<RequestHistoryEntity> removedRequest, ProjectEntity project) throws IOException {
        List<RequestHistoryEntity> requestHistoryEntities = this.store.getHistoryRequestEntities(project);
        requestHistoryEntities.removeAll(removedRequest);
        this.store.setRequestHistoryEntities(requestHistoryEntities, project);
        if (this.listener != null) {
            this.listener.removeHistoryRequests(removedRequest);
        }
    }

    public void addRequestHistory(RequestHistoryEntity requestHistory, ProjectEntity project) throws IOException {
        if (this.lastestRequest != null && this.lastestRequest.getRequest().equals((Object)requestHistory.getRequest())) {
            this.store.removeRequestHistory(this.lastestRequest, project);
        }
        this.store.addRequestHistory(requestHistory, project);
        this.lastestRequest = requestHistory;
    }

    public IRequestHistoryListener getListener() {
        return this.listener;
    }

    public void setListener(IRequestHistoryListener listener) {
        this.listener = listener;
    }
}

