/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.impl.tree.ApiCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.view.ApiCollectionGenerateTestUI;
import com.kms.katalon.composer.webservice.view.ApiCollectionPartUI;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.authorization.AwsSignatureLocation;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.BearerAuthorization;
import com.kms.katalon.core.testobject.authorization.NTLMAuthorization;
import com.kms.katalon.core.testobject.authorization.OAuth1Authorization;
import com.kms.katalon.core.testobject.authorization.OAuth1SignatureMethod;
import com.kms.katalon.core.testobject.authorization.OAuth2Authorization;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCollectionPart
extends WebServicePart {
    private static final Logger logger = LoggerFactory.getLogger(ApiCollectionPart.class);
    private static final String COLLECTION_PART_ID_PREFIX = "com.kms.katalon.composer.webservice.part.collection.";
    private ApiCollectionEntity apiCollectionEntity;
    private ApiCollectionPartUI apiCollectionPartUI;
    private ApiCollectionGenerateTestUI aiTestingTab;
    private static final String INHERIT_AUTH_FROM_PARENT = ComposerWebserviceMessageConstants.INHERIT_AUTH_FROM_PARENT;
    private long lastTreeRefreshTime = 0L;
    private String oldAuthType = null;
    private final ModifyListener dirtyListener = e -> this.setDirty(true);
    private final SelectionAdapter dirtySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ApiCollectionPart.this.setDirty(true);
        }
    };

    @Override
    @PostConstruct
    public void createComposite(Composite parent, MCompositePart part) {
        String partId = part.getElementId();
        String apiCollectionId = partId.substring(COLLECTION_PART_ID_PREFIX.length());
        try {
            this.apiCollectionEntity = (ApiCollectionEntity)FolderController.getInstance().getFolder(apiCollectionId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.createComposite(): ...", this.getClass().getName()));
            LoggerSingleton.logError((Throwable)e);
            throw new RuntimeException("Failed to load api collection: " + apiCollectionId, e);
        }
        this.mPart = part;
        this.parent = parent;
        this.originalWsObject = new WebServiceRequestEntity();
        part.setLabel(this.apiCollectionEntity.getName());
        part.setTooltip(this.apiCollectionEntity.getIdForDisplay());
        ApiCollectionPartUI collectionPartUI = new ApiCollectionPartUI(this.apiCollectionEntity);
        this.initComponents(collectionPartUI);
        parent.layout(true, true);
    }

    public void initComponents(ApiCollectionPartUI collectionPartUI) {
        this.apiCollectionPartUI = collectionPartUI;
        collectionPartUI.createAuthorizationTab(this.parent);
        if (this.apiCollectionEntity.getCollectionType() == ApiCollectionEntity.CollectionType.OPENAPI_3_0 && this.featureController != null && this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            String openApiSpecFilePath = this.getOpenApiSpecFilePath();
            CTabFolder tabFolder = collectionPartUI.getTabFolder();
            if (tabFolder != null) {
                this.aiTestingTab = new ApiCollectionGenerateTestUI(tabFolder, this.apiCollectionEntity, openApiSpecFilePath);
                this.aiTestingTab.registerButtonListener();
            }
        }
        this.initializeAuthorizationComponents();
        this.oldAuthType = this.apiCollectionPartUI.getCcbAuthType().getText();
        this.registerEventListeners();
        this.registerFolderUpdateListeners();
        this.parent.layout(true, true);
        this.populateDataToUI();
    }

    private void initializeAuthorizationComponents() {
        super.createBasicAuthInput(this.apiCollectionPartUI.getUserComposite());
        super.createBearerInput(this.apiCollectionPartUI.getBearerComposite());
        super.createNTMLInput(this.apiCollectionPartUI.getNtmlComposite());
        super.createAwsAuthInputForm(this.apiCollectionPartUI.getAwsSignatureComposite());
        super.createDigestAuthInputForm(this.apiCollectionPartUI.getDigestAuthorizationConfigUiContainer());
        this.apiCollectionPartUI.getDigestAuthorizationConfigUiContainer().addListener(1000, new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof WebServicePart.LayoutArrangementChangedEvent) {
                    ApiCollectionPart.this.apiCollectionPartUI.getDigestAuthorizationConfigUiContainer().layout(true);
                }
            }
        });
        super.createOAuth1Input(this.apiCollectionPartUI.getOauth1Composite());
        super.createOAuth2Input(this.apiCollectionPartUI.getOauth2Composite());
        this.addDirtyListeners();
        this.apiCollectionPartUI.addAuthTypeSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiCollectionPart.this.renderAuthenticationUI(ApiCollectionPart.this.apiCollectionPartUI.getCcbAuthType().getText());
                ApiCollectionPart.this.setDirty(true);
            }
        });
        this.apiCollectionPartUI.getCcbAuthType().select(0);
        this.renderAuthenticationUI(this.apiCollectionPartUI.getCcbAuthType().getText());
    }

    @Override
    protected void renderAuthenticationUI(String targetAuthType) {
        this.setCompositeVisible(this.apiCollectionPartUI.getUserComposite(), ComposerWebserviceMessageConstants.BASIC_AUTH.equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getOauth1Composite(), "OAuth 1.0".equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getOauth2Composite(), "OAuth 2.0".equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getNtmlComposite(), "NTLM".equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getBearerComposite(), "Bearer".equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getAwsSignatureComposite(), "AWS Signature".equals(targetAuthType));
        this.setCompositeVisible(this.apiCollectionPartUI.getDigestAuthorizationConfigUiContainer(), ComposerWebserviceMessageConstants.DIGEST_AUTH.equals(targetAuthType));
        boolean shouldShowConfig = this.shouldShowConfigurationDetails(targetAuthType);
        this.setConfigGroupVisible(shouldShowConfig);
    }

    private boolean shouldShowConfigurationDetails(String authType) {
        return authType != null && !ComposerWebserviceMessageConstants.NO_AUTH.equals(authType) && !INHERIT_AUTH_FROM_PARENT.equals(authType);
    }

    private void setConfigGroupVisible(boolean visible) {
        if (this.apiCollectionPartUI.getConfigGroup() != null && !this.apiCollectionPartUI.getConfigGroup().isDisposed()) {
            this.apiCollectionPartUI.getConfigGroup().setVisible(visible);
            GridData gridData = (GridData)this.apiCollectionPartUI.getConfigGroup().getLayoutData();
            if (gridData != null) {
                gridData.exclude = !visible;
            }
            this.apiCollectionPartUI.getConfigGroup().getParent().layout(true, true);
        }
    }

    private void addDirtyListeners() {
        Stream.of(this.txtUsername, this.txtPassword, this.txtBearerToken, this.txtNTLMUsername, this.txtNTLMPassword, this.txtNTLMDomain, this.txtNTLMWorkstation, this.txtAwsAccessKey, this.txtAwsSecretKey, this.txtAwsRegion, this.txtAwsServiceName, this.txtAwsSessionToken, this.digestAuthUsernameInput, this.digestAuthPasswordInput, this.digestAuthRealmInput, this.digestAuthNonceInput, this.digestAuthNonceCountInput, this.digestAuthClientNonceInput, this.digestAuthOpaqueInput, this.txtConsumerKeyOAuth1, this.txtConsumerSecretOAuth1, this.txtToken, this.txtTokenSecret, this.txtRealm, this.txtOAuth2Username, this.txtOAuth2Password, this.txtCallbackUrl, this.txtAuthUrl, this.txtAccessTokenUrl, this.txtState, this.txtConsumerKeyOAuth2, this.txtConsumerSecretOAuth2, this.txtAuthorizationCode, this.txtScope, this.txtAccessToken, this.txtRefreshToken, this.txtTokenType).filter(Objects::nonNull).forEach(field -> field.addModifyListener(this.dirtyListener));
        Stream.of(this.cbbAwsAddAuthDataTo, this.ccbOAuth1SignatureMethod, this.ccbOAuth2SignatureMethod, this.digestAuthAlgorithmCombo, this.digestAuthQopCombo).filter(Objects::nonNull).forEach(dropdown -> dropdown.addSelectionListener((SelectionListener)this.dirtySelectionListener));
        Stream.of(this.digestAuthRetryAutoButton, this.digestAuthRetryManualButton).filter(Objects::nonNull).forEach(button -> button.addSelectionListener((SelectionListener)this.dirtySelectionListener));
    }

    @Override
    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
    }

    @Override
    protected void populateDataToUI() {
        BasicRequestAuthorization savedAuth;
        this.httpHeaders.clear();
        if (this.originalWsObject != null) {
            this.originalWsObject.setAuthorizationRequest(this.apiCollectionEntity.getAuthorization());
        }
        if ((savedAuth = this.apiCollectionEntity.getAuthorization()) != null && savedAuth.getAuthorizationType() != null) {
            this.apiCollectionPartUI.getCcbAuthType().setText(savedAuth.getAuthorizationType());
            this.populateAuthorizationFromModel();
        } else {
            this.showCalculatedDefault();
        }
        this.renderAuthenticationUI(this.apiCollectionPartUI.getCcbAuthType().getText());
        this.setDirty(false);
    }

    private void showCalculatedDefault() {
        if (this.isTopMostFolder()) {
            this.apiCollectionPartUI.getCcbAuthType().setText(ComposerWebserviceMessageConstants.NO_AUTH);
        } else {
            this.apiCollectionPartUI.getCcbAuthType().setText(INHERIT_AUTH_FROM_PARENT);
        }
    }

    private boolean isTopMostFolder() {
        FolderEntity parent = this.apiCollectionEntity.getParentFolder();
        return parent == null || !(parent instanceof ApiCollectionEntity);
    }

    private boolean isCalculatedDefault(String authType) {
        BasicRequestAuthorization savedAuth = this.apiCollectionEntity.getAuthorization();
        if (savedAuth != null && savedAuth.getAuthorizationType() != null) {
            return false;
        }
        if (this.isTopMostFolder()) {
            return ComposerWebserviceMessageConstants.NO_AUTH.equals(authType);
        }
        return INHERIT_AUTH_FROM_PARENT.equals(authType);
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (this.dirtyable != null) {
            this.dirtyable.setDirty(isDirty);
        }
    }

    @Override
    protected void preSaving() {
        String authType = this.apiCollectionPartUI.getCcbAuthType().getText();
        BasicRequestAuthorization newAuth = null;
        this.httpHeaders.removeIf(header -> header.getName().equalsIgnoreCase("Authorization") || header.getName().startsWith("Authorization:"));
        try {
            if (INHERIT_AUTH_FROM_PARENT.equals(authType)) {
                newAuth = null;
            } else if (ComposerWebserviceMessageConstants.NO_AUTH.equals(authType)) {
                if (this.isCalculatedDefault(authType)) {
                    newAuth = null;
                } else {
                    newAuth = new BasicRequestAuthorization();
                    newAuth.setAuthorizationType(ComposerWebserviceMessageConstants.NO_AUTH);
                }
            } else if (ComposerWebserviceMessageConstants.BASIC_AUTH.equals(authType)) {
                BasicRequestAuthorization basicAuth = new BasicRequestAuthorization();
                HashMap<String, String> authInfo = new HashMap<String, String>();
                authInfo.put("username", this.txtUsername.getText());
                authInfo.put("password", this.txtPassword.getText());
                basicAuth.setAuthorizationInfo(authInfo);
                basicAuth.setAuthorizationType(ComposerWebserviceMessageConstants.BASIC_AUTH);
                newAuth = basicAuth;
                this.httpHeaders.add(new WebElementPropertyEntity("Authorization", "Basic " + Base64.basicEncode((String)this.txtUsername.getText(), (String)this.txtPassword.getText()), true));
            } else if ("Bearer".equals(authType)) {
                newAuth = new BearerAuthorization(this.txtBearerToken.getText());
                this.httpHeaders.add(new WebElementPropertyEntity("Authorization", "Bearer " + this.txtBearerToken.getText(), true));
            } else if ("NTLM".equals(authType)) {
                newAuth = new NTLMAuthorization(this.txtNTLMUsername.getText(), this.txtNTLMPassword.getText(), this.txtNTLMDomain.getText(), this.txtNTLMWorkstation.getText());
            } else {
                if ("AWS Signature".equals(authType)) {
                    try {
                        this.updateModelFromAwsAuthenticationInputForm();
                        newAuth = this.originalWsObject.getAuthorizationRequest();
                    }
                    catch (UnsupportedEncodingException | GeneralSecurityException e2) {
                        LoggerSingleton.logError((Throwable)e2);
                        throw new RuntimeException("Failed to create AWS auth", e2);
                    }
                }
                if (ComposerWebserviceMessageConstants.DIGEST_AUTH.equals(authType)) {
                    try {
                        this.updateModelWithDigestAuthenticationInputForm();
                        newAuth = this.originalWsObject.getAuthorizationRequest();
                    }
                    catch (UnsupportedEncodingException | GeneralSecurityException e2) {
                        LoggerSingleton.logError((Throwable)e2);
                        throw new RuntimeException("Failed to create Digest auth", e2);
                    }
                }
                if ("OAuth 1.0".equals(authType)) {
                    try {
                        this.createOAuth1Authentication();
                        newAuth = this.originalWsObject.getAuthorizationRequest();
                    }
                    catch (IOException | GeneralSecurityException e2) {
                        LoggerSingleton.logError((Throwable)e2);
                        throw new RuntimeException("Failed to create OAuth1 auth", e2);
                    }
                }
                if ("OAuth 2.0".equals(authType)) {
                    try {
                        this.createOAuth2Authentication();
                        newAuth = this.originalWsObject.getAuthorizationRequest();
                    }
                    catch (IOException | GeneralSecurityException e2) {
                        LoggerSingleton.logError((Throwable)e2);
                        throw new RuntimeException("Failed to create OAuth2 auth", e2);
                    }
                }
            }
            this.apiCollectionEntity.setAuthorization(newAuth);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to create Authorization object");
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)("Failed to save settings. Please check your inputs. Error: " + e.getMessage()));
            return;
        }
    }

    private static AwsSignatureLocation getAwsSignatureLocationByDisplayName(String displayName) {
        AwsSignatureLocation[] awsSignatureLocationArray = AwsSignatureLocation.values();
        int n = awsSignatureLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            AwsSignatureLocation location = awsSignatureLocationArray[n2];
            if (location.getDisplayName().equals(displayName)) {
                return location;
            }
            ++n2;
        }
        return AwsSignatureLocation.REQUEST_HEADER;
    }

    @Override
    @Persist
    public void save() {
        try {
            this.preSaving();
            String currentFolderId = this.getCurrentFolderId();
            ApiCollectionEntity currentFolder = (ApiCollectionEntity)FolderController.getInstance().getFolder(currentFolderId);
            if (currentFolder != null) {
                this.updateCurrentFolderWithUIChanges(currentFolder);
                FolderController.getInstance().saveFolder((FolderEntity)currentFolder);
                this.apiCollectionEntity = currentFolder;
                this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)currentFolder);
            } else {
                FolderController.getInstance().saveFolder((FolderEntity)this.apiCollectionEntity);
                this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.apiCollectionEntity);
            }
            String latestAuthType = this.apiCollectionPartUI.getCcbAuthType().getText();
            if (!this.oldAuthType.equalsIgnoreCase(latestAuthType)) {
                Trackings.trackApiCollectionAuthorizationChange((String)this.apiCollectionEntity.getName(), (String)this.apiCollectionEntity.getCollectionType().getDisplayName());
            }
            this.setDirty(false);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.save(): ...", this.getClass().getName()));
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)ComposerWebserviceMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_PART);
        }
    }

    private String getCurrentFolderId() {
        String partId = this.mPart.getElementId();
        if (partId != null && partId.startsWith(COLLECTION_PART_ID_PREFIX)) {
            return partId.substring(COLLECTION_PART_ID_PREFIX.length());
        }
        return this.apiCollectionEntity.getId();
    }

    private void updateCurrentFolderWithUIChanges(ApiCollectionEntity currentFolder) {
        if (this.apiCollectionEntity.getAuthorization() != null) {
            currentFolder.setAuthorization(this.apiCollectionEntity.getAuthorization());
        }
        currentFolder.setCollectionType(this.apiCollectionEntity.getCollectionType());
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    @Override
    public List<MPart> getChildParts() {
        return Collections.emptyList();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
    }

    private void registerFolderUpdateListeners() {
        this.eventBroker.subscribe("TESTOBJECT/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/CUT_PASTED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_TREE_ENTITY", (EventHandler)this);
    }

    @Override
    public void handleEvent(org.osgi.service.event.Event event) {
        block46: {
            String newPath;
            String oldPath;
            Object[] eventArray;
            Object eventData = EventUtil.getData((org.osgi.service.event.Event)event);
            if ("EXPLORER/REFRESH_TREE_ENTITY".equals(event.getTopic())) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastTreeRefreshTime < 1000L) {
                    return;
                }
                this.lastTreeRefreshTime = currentTime;
                Display.getCurrent().timerExec(1000, new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                String currentTooltip = ApiCollectionPart.this.mPart.getTooltip();
                                String folderId = ApiCollectionPart.this.apiCollectionEntity.getId();
                                String folderName = ApiCollectionPart.this.apiCollectionEntity.getName();
                                if (currentTooltip == null || folderId == null || folderName == null) break block6;
                                try {
                                    String foundPath;
                                    ApiCollectionEntity foundApiCollection;
                                    FolderEntity objectRepositoryRoot;
                                    ProjectEntity project = ApiCollectionPart.this.apiCollectionEntity.getProject();
                                    if (project != null && (objectRepositoryRoot = FolderController.getInstance().getObjectRepositoryRoot(project)) != null && (foundApiCollection = ApiCollectionPart.this.findApiCollection(objectRepositoryRoot, folderName, folderId, null)) != null && !(foundPath = foundApiCollection.getIdForDisplay()).equals(currentTooltip)) {
                                        ApiCollectionPart.this.apiCollectionEntity = foundApiCollection;
                                        ApiCollectionPart.this.mPart.setTooltip(foundPath);
                                        if (ApiCollectionPart.this.originalWsObject != null) {
                                            ApiCollectionPart.this.originalWsObject.setAuthorizationRequest(foundApiCollection.getAuthorization());
                                        }
                                        ApiCollectionPart.this.populateDataToUI();
                                        ApiCollectionPart.this.setDirty(false);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            catch (Exception exception) {}
                        }
                    }
                });
                return;
            }
            if ("TESTOBJECT/UPDATED".equals(event.getTopic())) {
                if (eventData == null) {
                    return;
                }
                if (eventData instanceof Object[] && (eventArray = (Object[])eventData).length == 2) {
                    String oldFolderId = (String)eventArray[0];
                    Object folderObj = eventArray[1];
                    if (folderObj instanceof ApiCollectionEntity) {
                        String ourParentPath;
                        ApiCollectionEntity folder = (ApiCollectionEntity)folderObj;
                        String oldElementId = COLLECTION_PART_ID_PREFIX + oldFolderId;
                        boolean isDirectMatch = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)oldElementId, (CharSequence)this.mPart.getElementId());
                        String currentFolderId = this.apiCollectionEntity.getId();
                        boolean isDescendantAffected = false;
                        if (currentFolderId.startsWith(oldFolderId + "/") || currentFolderId.equals(oldFolderId)) {
                            isDescendantAffected = true;
                        } else if (currentFolderId.contains("/") && (ourParentPath = currentFolderId.substring(0, currentFolderId.lastIndexOf("/"))).equals(oldFolderId)) {
                            isDescendantAffected = true;
                        }
                        String tabElementId = this.mPart.getElementId();
                        if (tabElementId != null && tabElementId.contains(oldFolderId)) {
                            isDescendantAffected = true;
                        }
                        if (isDirectMatch) {
                            String newPartId = COLLECTION_PART_ID_PREFIX + folder.getId();
                            this.mPart.setElementId(newPartId);
                            this.mPart.setLabel(folder.getName());
                            this.mPart.setTooltip(folder.getIdForDisplay());
                            this.apiCollectionEntity = folder;
                            if (this.originalWsObject != null) {
                                this.originalWsObject.setAuthorizationRequest(folder.getAuthorization());
                            }
                            this.populateDataToUI();
                            this.setDirty(false);
                            return;
                        }
                        if (isDescendantAffected) {
                            String newFolderId = currentFolderId.replace(oldFolderId, folder.getId());
                            String newPartId = COLLECTION_PART_ID_PREFIX + newFolderId;
                            String newDisplayPath = newFolderId.substring(newFolderId.indexOf("Object Repository/"));
                            this.mPart.setElementId(newPartId);
                            this.mPart.setTooltip(newDisplayPath);
                            try {
                                ApiCollectionEntity updatedFolder = (ApiCollectionEntity)FolderController.getInstance().getFolder(newFolderId);
                                if (updatedFolder != null) {
                                    this.apiCollectionEntity = updatedFolder;
                                    if (this.originalWsObject != null) {
                                        this.originalWsObject.setAuthorizationRequest(updatedFolder.getAuthorization());
                                    }
                                    this.populateDataToUI();
                                    this.setDirty(false);
                                }
                            }
                            catch (Exception exception) {}
                            return;
                        }
                    }
                }
                if (eventData instanceof TestObjectUpdatedEvent) {
                    TestObjectUpdatedEvent testObject = (TestObjectUpdatedEvent)eventData;
                    return;
                }
            }
            if ("EXPLORER/CUT_PASTED_SELECTED_ITEM".equals(event.getTopic()) && eventData instanceof Object[] && (eventArray = (Object[])eventData).length == 2) {
                oldPath = (String)eventArray[0];
                newPath = (String)eventArray[1];
                final String currentPath = this.apiCollectionEntity.getRelativePathForUI().replace('\\', '/');
                if (oldPath.equals(currentPath + "/")) {
                    String newPathString = (String)eventArray[1];
                    String newFolderId = newPathString.replace("/", File.separator).replace(this.apiCollectionEntity.getProject().getFolderLocation() + File.separator, "");
                    this.reloadApiCollection(newFolderId);
                    return;
                }
                final String oldPathPrefix = oldPath.endsWith("/") ? oldPath.substring(0, oldPath.length() - 1) : oldPath;
                boolean isAffectedByMove = false;
                if (currentPath.startsWith(oldPathPrefix + "/") || currentPath.equals(oldPathPrefix)) {
                    isAffectedByMove = true;
                }
                if (!isAffectedByMove) {
                    String[] currentPathParts = currentPath.split("/");
                    String[] oldPathParts = oldPathPrefix.split("/");
                    if (oldPathParts.length <= currentPathParts.length) {
                        boolean allPartsMatch = true;
                        int i = 0;
                        while (i < oldPathParts.length) {
                            if (!oldPathParts[i].equals(currentPathParts[i])) {
                                allPartsMatch = false;
                                break;
                            }
                            ++i;
                        }
                        if (allPartsMatch) {
                            isAffectedByMove = true;
                        }
                    }
                }
                if (isAffectedByMove) {
                    Display.getCurrent().timerExec(500, new Runnable(){

                        @Override
                        public void run() {
                            block12: {
                                try {
                                    ApiCollectionEntity refreshedFolder = null;
                                    try {
                                        refreshedFolder = (ApiCollectionEntity)FolderController.getInstance().getFolder(ApiCollectionPart.this.apiCollectionEntity.getId());
                                    }
                                    catch (Exception exception) {}
                                    if (refreshedFolder == null || refreshedFolder.getIdForDisplay().equals(currentPath)) {
                                        try {
                                            String expectedNewPath = currentPath.replace(oldPathPrefix, newPath);
                                            ApiCollectionPart.this.mPart.setTooltip(expectedNewPath);
                                            refreshedFolder = (ApiCollectionEntity)FolderController.getInstance().getFolder(ApiCollectionPart.this.apiCollectionEntity.getId());
                                            if (refreshedFolder != null) {
                                                ApiCollectionPart.this.apiCollectionEntity = refreshedFolder;
                                                if (ApiCollectionPart.this.originalWsObject != null) {
                                                    ApiCollectionPart.this.originalWsObject.setAuthorizationRequest(refreshedFolder.getAuthorization());
                                                }
                                                ApiCollectionPart.this.populateDataToUI();
                                                ApiCollectionPart.this.setDirty(false);
                                                String actualPath = refreshedFolder.getIdForDisplay();
                                                ApiCollectionPart.this.mPart.setTooltip(actualPath);
                                            }
                                            break block12;
                                        }
                                        catch (Exception exception) {}
                                        break block12;
                                    }
                                    ApiCollectionPart.this.apiCollectionEntity = refreshedFolder;
                                    ApiCollectionPart.this.mPart.setTooltip(refreshedFolder.getIdForDisplay());
                                    if (ApiCollectionPart.this.originalWsObject != null) {
                                        ApiCollectionPart.this.originalWsObject.setAuthorizationRequest(refreshedFolder.getAuthorization());
                                    }
                                    ApiCollectionPart.this.populateDataToUI();
                                    ApiCollectionPart.this.setDirty(false);
                                }
                                catch (Exception exception) {
                                    try {
                                        String expectedNewPath = currentPath.replace(oldPathPrefix, newPath);
                                        ApiCollectionPart.this.mPart.setTooltip(expectedNewPath + " (calculated)");
                                    }
                                    catch (Exception exception2) {
                                        ApiCollectionPart.this.mPart.setTooltip("Path may be outdated - please close and reopen tab");
                                    }
                                }
                            }
                        }
                    });
                    return;
                }
            }
            if ("EXPLORER/RENAMED_SELECTED_ITEM".equals(event.getTopic()) && eventData instanceof Object[] && (eventArray = (Object[])eventData).length == 2) {
                boolean isAffected;
                oldPath = (String)eventArray[0];
                newPath = (String)eventArray[1];
                String currentFolderRelativePath = this.apiCollectionEntity.getRelativePathForUI().replace('\\', '/') + "/";
                if (oldPath.endsWith("/")) {
                    String pathWithoutSlash = oldPath.substring(0, oldPath.length() - 1);
                    pathWithoutSlash.substring(pathWithoutSlash.lastIndexOf(47) + 1);
                } else {
                    oldPath.substring(oldPath.lastIndexOf(47) + 1);
                }
                this.apiCollectionEntity.getName();
                boolean isThisFolderRenamed = currentFolderRelativePath.equals(oldPath);
                boolean isParentAffected = false;
                Object reconstructedOldPath = currentFolderRelativePath;
                if (oldPath.endsWith("/") && newPath.endsWith("/")) {
                    reconstructedOldPath = currentFolderRelativePath.replace(newPath, oldPath);
                }
                if (oldPath.endsWith("/")) {
                    isParentAffected = ((String)reconstructedOldPath).startsWith(oldPath);
                }
                boolean bl = isAffected = isThisFolderRenamed || isParentAffected;
                if (isAffected) {
                    try {
                        String targetPath;
                        if (isThisFolderRenamed) {
                            targetPath = newPath;
                        } else {
                            String cur = currentFolderRelativePath;
                            Object oldP = oldPath.endsWith("/") ? oldPath : oldPath + "/";
                            Object newP = newPath.endsWith("/") ? newPath : newPath + "/";
                            targetPath = cur.replace((CharSequence)oldP, (CharSequence)newP);
                        }
                        String newFolderId = this.constructNewFolderId(targetPath);
                        this.reloadApiCollection(newFolderId);
                        if (this.apiCollectionEntity == null) {
                            String fallbackName = targetPath.substring(targetPath.lastIndexOf(47) + 1);
                            if (fallbackName.endsWith("/")) {
                                fallbackName = fallbackName.substring(0, fallbackName.length() - 1);
                            }
                            this.mPart.setTooltip(targetPath.endsWith("/") ? targetPath.substring(0, targetPath.length() - 1) : targetPath);
                        }
                    }
                    catch (Exception exception) {
                        Object oldP = oldPath.endsWith("/") ? oldPath : oldPath + "/";
                        Object newP = newPath.endsWith("/") ? newPath : newPath + "/";
                        String targetPath = currentFolderRelativePath.replace((CharSequence)oldP, (CharSequence)newP);
                        this.mPart.setTooltip(targetPath.endsWith("/") ? targetPath.substring(0, targetPath.length() - 1) : targetPath);
                    }
                    return;
                }
            }
            if ("EXPLORER/REFRESH_SELECTED_ITEM".equals(event.getTopic())) {
                try {
                    ApiCollectionTreeEntity apiCollectionTreeEntity;
                    ApiCollectionEntity folder;
                    if (!(eventData instanceof ITreeEntity)) {
                        return;
                    }
                    if (!(eventData instanceof ApiCollectionTreeEntity) || (folder = (apiCollectionTreeEntity = (ApiCollectionTreeEntity)eventData).getObject()) == null || !folder.getId().equals(this.apiCollectionEntity.getId())) break block46;
                    try {
                        FolderEntity existingFolder = FolderController.getInstance().getFolder(folder.getId());
                        if (existingFolder == null) {
                            this.dispose();
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.dispose();
                        return;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.handleEvents():  failed to dispatch events...", this.getClass().getName()));
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
    }

    private ApiCollectionEntity findApiCollection(FolderEntity rootFolder, String folderName, String folderId, String expectedPath) {
        try {
            List childFolders = FolderController.getInstance().getChildFolders(rootFolder);
            for (FolderEntity childFolder : childFolders) {
                ApiCollectionEntity found;
                if (childFolder instanceof ApiCollectionEntity) {
                    ApiCollectionEntity apiCollection = (ApiCollectionEntity)childFolder;
                    if (folderName != null && folderId != null && folderName.equals(apiCollection.getName()) && folderId.equals(apiCollection.getId())) {
                        return apiCollection;
                    }
                    if (folderName != null && folderId == null && expectedPath == null && folderName.equals(apiCollection.getName())) {
                        return apiCollection;
                    }
                    if (folderName != null && expectedPath != null) {
                        String actualPath = apiCollection.getIdForDisplay();
                        if (folderName.equals(apiCollection.getName()) && expectedPath.equals(actualPath)) {
                            return apiCollection;
                        }
                        if (expectedPath.endsWith(folderName) && actualPath.endsWith(folderName)) {
                            String expectedParent = expectedPath.substring(0, expectedPath.lastIndexOf("/" + folderName));
                            String actualParent = actualPath.substring(0, actualPath.lastIndexOf("/" + folderName));
                            if (expectedParent.contains("c2/f") && actualParent.contains("c2/f")) {
                                return apiCollection;
                            }
                        }
                    }
                }
                if ((found = this.findApiCollection(childFolder, folderName, folderId, expectedPath)) == null) continue;
                return found;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private String constructNewFolderId(String newPath) {
        String projectLocation = this.apiCollectionEntity.getProject().getFolderLocation();
        String newPathWithoutSlash = newPath.endsWith("/") ? newPath.substring(0, newPath.length() - 1) : newPath;
        return projectLocation + File.separator + newPathWithoutSlash.replace('/', File.separatorChar);
    }

    private void reloadApiCollection(String newFolderId) {
        try {
            ApiCollectionEntity newApiCollectionEntity = (ApiCollectionEntity)FolderController.getInstance().getFolder(newFolderId);
            if (newApiCollectionEntity != null) {
                this.apiCollectionEntity = newApiCollectionEntity;
                String newPartId = COLLECTION_PART_ID_PREFIX + newApiCollectionEntity.getId();
                this.mPart.setElementId(newPartId);
                this.mPart.setLabel(newApiCollectionEntity.getName());
                this.mPart.setTooltip(newApiCollectionEntity.getIdForDisplay());
                this.populateDataToUI();
                this.dirtyable.setDirty(false);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.reloadApiCollection(): ...", this.getClass().getName()));
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    protected void setCompositeVisible(Composite composite, boolean isVisible) {
        Composite parent;
        if (composite == null || composite.isDisposed()) {
            return;
        }
        composite.setVisible(isVisible);
        GridData gridData = (GridData)composite.getLayoutData();
        if (gridData != null) {
            boolean bl = gridData.exclude = !isVisible;
        }
        if ((parent = composite.getParent()) != null && !parent.isDisposed()) {
            parent.layout(true, true);
        }
    }

    @Override
    protected void createServiceInfoComposite(Composite parent) {
    }

    @Override
    protected void sendRequest(boolean runVerificationScript) {
    }

    @Override
    protected ResponseObject getResponseObjectFromEditor() {
        return null;
    }

    @Override
    protected void updatePartImage() {
    }

    @Override
    protected void populateBasicAndBearerAuthFromHeader() {
        BasicRequestAuthorization auth = this.apiCollectionEntity.getAuthorization();
        if (auth == null || auth.getAuthorizationType() == null) {
            return;
        }
        try {
            String authType = auth.getAuthorizationType();
            Map authInfo = auth.getAuthorizationInfo();
            if (ComposerWebserviceMessageConstants.BASIC_AUTH.equals(authType)) {
                this.populateBasicAuthFields(authInfo);
            } else if ("Bearer".equals(authType)) {
                this.populateBearerAuthFields(authInfo);
            }
        }
        catch (Exception e) {
            logger.error("ApiCollectionPart.populateBasicAndBearerAuthFromHeader() - Error populating fields", (Throwable)e);
            this.clearAuthFields();
        }
    }

    private void populateBasicAuthFields(Map<String, String> authInfo) {
        if (authInfo != null) {
            String username = authInfo.get("username");
            String password = authInfo.get("password");
            if (this.txtUsername != null) {
                this.txtUsername.setText(username != null ? username : "");
            }
            if (this.txtPassword != null) {
                this.txtPassword.setText(password != null ? password : "");
            }
        }
    }

    private void populateBearerAuthFields(Map<String, String> authInfo) {
        if (authInfo != null) {
            String bearerToken = authInfo.get("bearerToken");
            if (this.txtBearerToken != null) {
                this.txtBearerToken.setText(bearerToken != null ? bearerToken : "");
            }
        }
    }

    private void clearAuthFields() {
        if (this.txtUsername != null) {
            this.txtUsername.setText("");
        }
        if (this.txtPassword != null) {
            this.txtPassword.setText("");
        }
        if (this.txtBearerToken != null) {
            this.txtBearerToken.setText("");
        }
    }

    @Override
    public WebServiceRequestEntity getWSRequestObject() {
        if (this.originalWsObject == null) {
            this.originalWsObject = new WebServiceRequestEntity();
        }
        return this.originalWsObject;
    }

    @Override
    public String getEntityId() {
        return this.apiCollectionEntity != null ? this.apiCollectionEntity.getId() : "unknown";
    }

    @Override
    public String getPartId() {
        return this.mPart != null ? this.mPart.getElementId() : "unknown";
    }

    @Override
    public boolean isDraft() {
        return false;
    }

    @Override
    protected CCombo getCcbAuthType() {
        return this.apiCollectionPartUI.getCcbAuthType();
    }

    private void populateAuthorizationFromModel() {
        if (this.originalWsObject != null && this.originalWsObject.getAuthorizationRequest() != null) {
            try {
                String authType = this.originalWsObject.getAuthorizationRequest().getAuthorizationType();
                if (authType != null) {
                    this.populateAuthFieldsByType(authType);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)"Failed to populate authorization UI from model");
            }
        }
    }

    private void populateAuthFieldsByType(String authType) {
        switch (authType) {
            case "Basic": 
            case "Bearer": {
                this.populateBasicAndBearerAuthFromHeader();
                break;
            }
            case "NTLM": {
                this.populateNTLMAuthorization();
                break;
            }
            case "OAuth 1.0": {
                this.updateOAuth1AuthorizationInputFormFromModel();
                break;
            }
            case "OAuth 2.0": {
                this.updateOAuth2AuthorizationInputFormFromModel();
                break;
            }
            case "AWS Signature": {
                this.updateAwsAuthorizationInputFormFromModel();
                break;
            }
            case "Digest": {
                this.updateDigestAuthenticationInputFormFromModel();
                break;
            }
        }
    }

    @Override
    protected void createOAuth1Authentication() throws GeneralSecurityException, IOException {
        String consumerKey = this.txtConsumerKeyOAuth1.getText();
        String consumerSecret = this.txtConsumerSecretOAuth1.getText();
        String signatureMethod = this.ccbOAuth1SignatureMethod.getText();
        String token = this.txtToken.getText();
        String tokenSecret = this.txtTokenSecret.getText();
        String realm = this.txtRealm.getText();
        if (StringUtils.isBlank((String)consumerKey) || StringUtils.isBlank((String)signatureMethod)) {
            this.originalWsObject.setAuthorizationRequest(null);
            return;
        }
        OAuth1Authorization oauth1Auth = new OAuth1Authorization(consumerKey, consumerSecret, OAuth1SignatureMethod.fromDisplayName((String)signatureMethod), token, tokenSecret, realm);
        this.originalWsObject.setAuthorizationRequest((BasicRequestAuthorization)oauth1Auth);
    }

    @Override
    protected void createOAuth2Authentication() throws GeneralSecurityException, IOException {
        String grantType = this.ccbOAuth2SignatureMethod.getText();
        if (StringUtils.isBlank((String)grantType)) {
            this.originalWsObject.setAuthorizationRequest(null);
            return;
        }
        try {
            OAuth2Authorization oauth2Auth = this.prepareOAuth2Authorization();
            this.originalWsObject.setAuthorizationRequest((BasicRequestAuthorization)oauth2Auth);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to create OAuth2 authorization");
            throw e;
        }
    }

    private String getOpenApiSpecFilePath() {
        if (this.apiCollectionEntity == null) {
            return null;
        }
        String openApiSpecFileName = this.apiCollectionEntity.getOpenApiSpecFileName();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openApiSpecFileName)) {
            return null;
        }
        String openApiFolderPath = this.apiCollectionEntity.getProject().getFolderLocation() + File.separator + ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME;
        File openApiFile = new File(openApiFolderPath, openApiSpecFileName);
        if (openApiFile.exists()) {
            return openApiFile.getAbsolutePath();
        }
        return null;
    }
}

