/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ApiKeyAuth
extends Auth {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String IN = "in";
    private static final String HEADER = "header";
    @JsonProperty(value="apikey")
    private List<AuthParameter> apikey = new ArrayList<AuthParameter>();

    public ApiKeyAuth() {
        super("apikey");
    }

    public List<AuthParameter> getApikey() {
        return this.apikey;
    }

    public void setApikey(List<AuthParameter> apikey) {
        this.apikey = apikey;
    }

    @Override
    public List<WebElementPropertyEntity> buildAuthorizationHeaders() {
        List<AuthParameter> apikeyItems = this.getApikey();
        Map<String, String> authInfo = apikeyItems.stream().filter(item -> item.getKey() != null && item.getValue() != null).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (first, second) -> first));
        String key = authInfo.getOrDefault(KEY, "");
        String value = authInfo.getOrDefault(VALUE, "");
        String in = authInfo.getOrDefault(IN, HEADER);
        if (HEADER.equals(in) && StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            WebElementPropertyEntity authenticationProp = new WebElementPropertyEntity();
            authenticationProp.setName(key);
            authenticationProp.setValue(value);
            authenticationProp.setIsSelected(true);
            return List.of(authenticationProp);
        }
        return new ArrayList<WebElementPropertyEntity>();
    }
}

