/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.AwsSignatureAuthorization;
import com.kms.katalon.core.testobject.authorization.AwsSignatureLocation;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AwsV4Auth
extends Auth {
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String REGION = "region";
    private static final String SERVICE = "service";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String ADD_AUTH_DATA_TO_QUERY = "addAuthDataToQuery";
    @JsonProperty(value="awsv4")
    List<AuthParameter> awsv4 = new ArrayList<AuthParameter>();

    public List<AuthParameter> getAwsv4() {
        return this.awsv4;
    }

    public void setAwsv4(List<AuthParameter> awsv4) {
        this.awsv4 = awsv4;
    }

    public AwsV4Auth() {
        super("awsv4");
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() throws UnsupportedEncodingException, GeneralSecurityException {
        List<AuthParameter> awsItems = this.getAwsv4();
        HashMap authorizationInfo = new HashMap();
        awsItems.forEach(item -> {
            if (item.getKey() != null && item.getValue() != null) {
                authorizationInfo.put(item.getKey(), item.getValueAsString());
            }
        });
        String accessKey = authorizationInfo.getOrDefault(ACCESS_KEY, "");
        String secretKey = authorizationInfo.getOrDefault(SECRET_KEY, "");
        String region = authorizationInfo.getOrDefault(REGION, "");
        String serviceName = authorizationInfo.getOrDefault(SERVICE, "");
        String sessionToken = authorizationInfo.getOrDefault(SESSION_TOKEN, "");
        boolean addToQuery = false;
        String addToQueryStr = (String)authorizationInfo.get(ADD_AUTH_DATA_TO_QUERY);
        if (StringUtils.isNotBlank((CharSequence)addToQueryStr)) {
            addToQuery = Boolean.parseBoolean(addToQueryStr);
        }
        AwsSignatureLocation location = addToQuery ? AwsSignatureLocation.QUERY_STRING : AwsSignatureLocation.REQUEST_HEADER;
        try {
            return new AwsSignatureAuthorization(location, accessKey, secretKey, region, serviceName, sessionToken);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Invalid AWS Signature Authorization parameters", (Throwable)e);
            throw new UnsupportedOperationException("Invalid AWS Signature Authorization parameters", e);
        }
        catch (Exception e) {
            this.logger.error("Error creating AWS Signature Authorization", (Throwable)e);
            throw new UnsupportedOperationException("Error creating AWS Signature Authorization", e);
        }
    }
}

