/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BasicAuth
extends Auth {
    private static final String AUTH_TYPE = "Basic";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    @JsonProperty(value="basic")
    private List<AuthParameter> basic = new ArrayList<AuthParameter>();

    public BasicAuth() {
        super("basic");
    }

    public List<AuthParameter> getBasic() {
        return this.basic;
    }

    public void setBasic(List<AuthParameter> basic) {
        this.basic = basic;
    }

    @Override
    public List<WebElementPropertyEntity> buildAuthorizationHeaders() {
        List<AuthParameter> basicItems = this.getBasic();
        Map<String, String> credentials = basicItems.stream().filter(item -> USERNAME_KEY.equals(item.getKey()) || PASSWORD_KEY.equals(item.getKey())).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (first, second) -> first));
        String username = credentials.getOrDefault(USERNAME_KEY, "");
        String password = credentials.getOrDefault(PASSWORD_KEY, "");
        WebElementPropertyEntity authenticationProp = new WebElementPropertyEntity();
        authenticationProp.setName("Authorization");
        authenticationProp.setValue("Basic " + Base64.basicEncode((String)username, (String)password));
        authenticationProp.setIsSelected(true);
        return List.of(authenticationProp);
    }
}

