/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.BearerAuthorization;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BearerTokenAuth
extends Auth {
    private static final String BEARER_AUTH_PREFIX_VALUE = ComposerWebserviceMessageConstants.BEARER_AUTH_PREFIX_VALUE;
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String TOKEN = "token";
    @JsonProperty(value="bearer")
    private List<AuthParameter> bearer = new ArrayList<AuthParameter>();

    public BearerTokenAuth() {
        super("bearer");
    }

    public List<AuthParameter> getBearer() {
        return this.bearer;
    }

    public void setBearer(List<AuthParameter> bearer) {
        this.bearer = bearer;
    }

    @Override
    public List<WebElementPropertyEntity> buildAuthorizationHeaders() {
        List<AuthParameter> bearerItems = this.getBearer();
        String bearerToken = bearerItems.stream().filter(item -> TOKEN.equals(item.getKey())).map(AuthParameter::getValueAsString).findFirst().orElse("");
        WebElementPropertyEntity authenticationProp = new WebElementPropertyEntity(HTTP_HEADER_AUTHORIZATION, BEARER_AUTH_PREFIX_VALUE + " " + bearerToken);
        authenticationProp.setIsSelected(true);
        return List.of(authenticationProp);
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() {
        List<AuthParameter> bearerItems = this.getBearer();
        String bearerToken = bearerItems.stream().filter(item -> TOKEN.equals(item.getKey())).map(AuthParameter::getValueAsString).findFirst().orElse("");
        if (bearerToken.isEmpty()) {
            return null;
        }
        return new BearerAuthorization(bearerToken);
    }
}

