/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.report;

import com.kms.katalon.composer.webservice.report.CatsHtmlReportGenerator;
import com.kms.katalon.composer.webservice.report.CatsReportParser;
import com.kms.katalon.composer.webservice.service.CatsExecutionService;
import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionExecutionSummary;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAiTestReportGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ApiAiTestReportGenerator.class);
    private final ApiCollectionEntity apiCollectionEntity;
    private final String openApiSpecFilePath;
    private final CatsReportParser catsReportParser;
    private final CatsHtmlReportGenerator htmlReportGenerator;

    public ApiAiTestReportGenerator(ApiCollectionEntity apiCollectionEntity, String openApiSpecFilePath) {
        this.apiCollectionEntity = apiCollectionEntity;
        this.openApiSpecFilePath = openApiSpecFilePath;
        this.catsReportParser = new CatsReportParser();
        this.htmlReportGenerator = new CatsHtmlReportGenerator();
    }

    public int executeAiTests(IProgressMonitor monitor, String serverUrl, List<String> selectedTestTypes, List<String> selectedApiPaths, List<String> selectedHttpMethods, BasicRequestAuthorization authorization, Map<String, String> allHttpMethods) throws InterruptedException {
        CatsExecutionService executionService = new CatsExecutionService(this.apiCollectionEntity, this.openApiSpecFilePath);
        return executionService.executeAiTests(monitor, serverUrl, selectedTestTypes, selectedApiPaths, selectedHttpMethods, authorization, allHttpMethods);
    }

    public String getTestTypeFromFuzzer(String fuzzer) {
        return this.catsReportParser.getTestTypeFromFuzzer(fuzzer);
    }

    public String getCatsReportFolderPath() {
        CatsExecutionService executionService = new CatsExecutionService(this.apiCollectionEntity, this.openApiSpecFilePath);
        return executionService.getCatsReportFolderPath();
    }

    private String getCatsSummaryReportJsonPath() {
        String catsReportFolder = this.getCatsReportFolderPath();
        if (catsReportFolder == null) {
            return null;
        }
        return catsReportFolder + File.separator + "cats-summary-report.json";
    }

    public ApiCollectionExecutionSummary parseExecutionSummaryWithReportGeneration() {
        String summaryJsonPath = this.getCatsSummaryReportJsonPath();
        if (summaryJsonPath == null) {
            logger.warn("Unable to determine summary JSON path");
            return null;
        }
        ApiCollectionExecutionSummary executionSummary = this.catsReportParser.parseTestResults(summaryJsonPath);
        if (executionSummary != null) {
            this.generateHtmlReport();
        }
        return executionSummary;
    }

    public void generateHtmlReport() {
        String summaryJsonPath = this.getCatsSummaryReportJsonPath();
        if (summaryJsonPath == null) {
            logger.warn("Unable to determine summary JSON path for HTML report generation");
            return;
        }
        File summaryJsonFile = new File(summaryJsonPath);
        String reportFolderPath = this.getCatsReportFolderPath();
        this.htmlReportGenerator.createCustomReport(summaryJsonFile, reportFolderPath);
    }

    public void openReportInBrowser() {
        try {
            String catsReportFolder = this.getCatsReportFolderPath();
            if (catsReportFolder == null) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Unable to determine report folder. Please ensure OpenAPI specification file is available.");
                return;
            }
            File reportDir = new File(catsReportFolder);
            if (!reportDir.exists()) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Report Not Found", (String)"The report is not available. Please run the AI tests first to generate it.");
                return;
            }
            File indexHtmlFile = new File(reportDir, "ai_test_report.html");
            if (!indexHtmlFile.exists()) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Report Not Found", (String)("Report file does not exist yet. Please run AI tests first to generate the report.\n\nExpected location: " + indexHtmlFile.getAbsolutePath()));
                return;
            }
            Program.launch((String)indexHtmlFile.toURI().toString());
            logger.info("Opened AI report in browser: {}", (Object)indexHtmlFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to open report in browser", (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Failed to open report in browser: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName())));
        }
    }
}

