/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.report;

import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionExecutionSummary;
import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionTestResultSummary;
import com.kms.katalon.composer.webservice.viewmodel.TestResultStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResultStatisticsCalculator {
    private static final Logger logger = LoggerFactory.getLogger(TestResultStatisticsCalculator.class);

    public TestResultStatistics calculateStatistics(ApiCollectionExecutionSummary testResult) {
        block3: {
            try {
                if (testResult != null) break block3;
                logger.warn("Cannot calculate statistics - test result is null");
                return null;
            }
            catch (Exception e) {
                logger.error("Failed to calculate test statistics", (Throwable)e);
                return null;
            }
        }
        TestTypeCounters counters = this.calculateTestTypeCounters(testResult);
        return new TestResultStatistics(testResult.totalTests(), testResult.passedTests(), testResult.failedTests(), testResult.warningTests(), counters.passedPositive, counters.failedPositive, counters.warningsPositive, counters.passedNegative, counters.failedNegative, counters.warningsNegative, counters.passedSecurity, counters.failedSecurity, counters.warningsSecurity, counters.passedEdgeCase, counters.failedEdgeCase, counters.warningsEdgeCase);
    }

    public TestTypeCounters calculateTestTypeCounters(ApiCollectionExecutionSummary testResult) {
        TestTypeCounters counters = new TestTypeCounters();
        List<ApiCollectionTestResultSummary> list = testResult.apiCollectionTestResultSummaryList();
        if (list == null) {
            return counters;
        }
        Map<String, List<ApiCollectionTestResultSummary>> categorizedTests = list.stream().filter(detail -> detail.result() != null && detail.testType() != null).collect(Collectors.groupingBy(ApiCollectionTestResultSummary::testType));
        categorizedTests.forEach((testType, tests) -> {
            Map<String, Long> resultCounts = tests.stream().collect(Collectors.groupingBy(detail -> detail.result().toLowerCase(), Collectors.counting()));
            long passed = resultCounts.getOrDefault("success", 0L);
            long failed = resultCounts.getOrDefault("error", 0L);
            long warnings = resultCounts.getOrDefault("warn", 0L);
            counters.addCounts((String)testType, passed, failed, warnings);
        });
        return counters;
    }

    public static class TestTypeCounters {
        int passedPositive = 0;
        int passedNegative = 0;
        int passedSecurity = 0;
        int passedEdgeCase = 0;
        int failedPositive = 0;
        int failedNegative = 0;
        int failedSecurity = 0;
        int failedEdgeCase = 0;
        int warningsPositive = 0;
        int warningsNegative = 0;
        int warningsSecurity = 0;
        int warningsEdgeCase = 0;

        void addCounts(String testType, long passed, long failed, long warnings) {
            if ("Positive Testing".equals(testType)) {
                this.passedPositive = (int)((long)this.passedPositive + passed);
                this.failedPositive = (int)((long)this.failedPositive + failed);
                this.warningsPositive = (int)((long)this.warningsPositive + warnings);
            } else if ("Negative Testing".equals(testType)) {
                this.passedNegative = (int)((long)this.passedNegative + passed);
                this.failedNegative = (int)((long)this.failedNegative + failed);
                this.warningsNegative = (int)((long)this.warningsNegative + warnings);
            } else if ("Security Testing".equals(testType)) {
                this.passedSecurity = (int)((long)this.passedSecurity + passed);
                this.failedSecurity = (int)((long)this.failedSecurity + failed);
                this.warningsSecurity = (int)((long)this.warningsSecurity + warnings);
            } else if ("Edge Case Testing".equals(testType)) {
                this.passedEdgeCase = (int)((long)this.passedEdgeCase + passed);
                this.failedEdgeCase = (int)((long)this.failedEdgeCase + failed);
                this.warningsEdgeCase = (int)((long)this.warningsEdgeCase + warnings);
            }
        }

        public String toString() {
            return "TestTypeCounters{passedPositive=" + this.passedPositive + ", passedNegative=" + this.passedNegative + ", passedSecurity=" + this.passedSecurity + ", passedEdgeCase=" + this.passedEdgeCase + ", failedPositive=" + this.failedPositive + ", failedNegative=" + this.failedNegative + ", failedSecurity=" + this.failedSecurity + ", failedEdgeCase=" + this.failedEdgeCase + ", warningsPositive=" + this.warningsPositive + ", warningsNegative=" + this.warningsNegative + ", warningsSecurity=" + this.warningsSecurity + ", warningsEdgeCase=" + this.warningsEdgeCase + "}";
        }
    }
}

